/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.config;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.group.RowGroupHeaderTextPainter;
import org.eclipse.nebula.widgets.nattable.group.action.RowGroupExpandCollapseAction;
import org.eclipse.nebula.widgets.nattable.group.model.IRowGroupModel;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.BeveledBorderDecorator;
import org.eclipse.nebula.widgets.nattable.selection.action.SelectRowGroupsAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;

public class DefaultRowGroupHeaderLayerConfiguration<T>
implements IConfiguration {
    private final IRowGroupModel<T> rowGroupModel;

    public DefaultRowGroupHeaderLayerConfiguration(IRowGroupModel<T> rowGroupModel) {
        this.rowGroupModel = rowGroupModel;
    }

    @Override
    public void configureLayer(ILayer layer) {
    }

    @Override
    public void configureRegistry(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, new BeveledBorderDecorator(new RowGroupHeaderTextPainter<T>(this.rowGroupModel)), "NORMAL", "ROW_GROUP_HEADER");
    }

    @Override
    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        SelectRowGroupsAction action = new SelectRowGroupsAction();
        uiBindingRegistry.registerSingleClickBinding(MouseEventMatcher.rowGroupHeaderLeftClick(0), action);
        uiBindingRegistry.registerSingleClickBinding(MouseEventMatcher.rowGroupHeaderLeftClick(262144), action);
        uiBindingRegistry.registerSingleClickBinding(MouseEventMatcher.rowGroupHeaderLeftClick(131072), action);
        uiBindingRegistry.registerDoubleClickBinding(MouseEventMatcher.rowGroupHeaderLeftClick(0), new RowGroupExpandCollapseAction());
    }
}

