/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.command;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupReorderLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiColumnReorderCommand;

public class GroupMultiColumnReorderCommandHandler
extends AbstractLayerCommandHandler<MultiColumnReorderCommand> {
    private final ColumnGroupReorderLayer columnGroupReorderLayer;

    public GroupMultiColumnReorderCommandHandler(ColumnGroupReorderLayer columnGroupReorderLayer) {
        this.columnGroupReorderLayer = columnGroupReorderLayer;
    }

    @Override
    public Class<MultiColumnReorderCommand> getCommandClass() {
        return MultiColumnReorderCommand.class;
    }

    @Override
    protected boolean doCommand(MultiColumnReorderCommand command) {
        ColumnGroupModel model;
        List<Integer> fromColumnPositions;
        int toColumnIndex;
        int toColumnPosition = command.getToColumnPosition();
        ILayer underlyingLayer = this.columnGroupReorderLayer.getUnderlyingLayer();
        if (this.updateModel(underlyingLayer, toColumnIndex = underlyingLayer.getColumnIndexByPosition(toColumnPosition), fromColumnPositions = command.getFromColumnPositions(), model = this.columnGroupReorderLayer.getModel())) {
            return underlyingLayer.doCommand(command);
        }
        return false;
    }

    private boolean updateModel(ILayer underlyingLayer, int toColumnIndex, List<Integer> fromColumnPositions, ColumnGroupModel model) {
        if (model.isPartOfAGroup(toColumnIndex)) {
            ColumnGroupModel.ColumnGroup toColumnGroup = model.getColumnGroupByIndex(toColumnIndex);
            String toGroupName = toColumnGroup.getName();
            if (model.isPartOfAnUnbreakableGroup(toColumnIndex)) {
                return false;
            }
            for (Integer fromColumnPosition : fromColumnPositions) {
                int fromColumnIndex = underlyingLayer.getColumnIndexByPosition(fromColumnPosition);
                ColumnGroupModel.ColumnGroup fromColumnGroup = model.getColumnGroupByIndex(fromColumnIndex);
                if (fromColumnGroup == toColumnGroup) continue;
                if (fromColumnGroup != null) {
                    fromColumnGroup.removeColumn(fromColumnIndex);
                }
                model.addColumnsIndexesToGroup(toGroupName, fromColumnIndex);
            }
            return true;
        }
        if (!model.isPartOfAGroup(toColumnIndex)) {
            for (Integer fromColumnPosition : fromColumnPositions) {
                int fromColumnIndex = underlyingLayer.getColumnIndexByPosition(fromColumnPosition);
                ColumnGroupModel.ColumnGroup fromColumnGroup = model.getColumnGroupByIndex(fromColumnIndex);
                if (fromColumnGroup == null || fromColumnGroup.removeColumn(fromColumnIndex)) continue;
                return false;
            }
            return true;
        }
        return true;
    }
}

