/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.group.RowGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.model.IRowGroup;
import org.eclipse.nebula.widgets.nattable.group.model.IRowGroupModel;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.CellPainterWrapper;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ImagePainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class RowGroupHeaderTextPainter<T>
extends CellPainterWrapper {
    private final IRowGroupModel<T> rowGroupModel;

    public RowGroupHeaderTextPainter(IRowGroupModel<T> rowGroupModel) {
        this.rowGroupModel = rowGroupModel;
        this.setWrappedPainter(new CellPainterDecorator(new TextPainter(), CellEdgeEnum.BOTTOM, new ExpandCollapseImagePainter()));
    }

    public RowGroupHeaderTextPainter(IRowGroupModel<T> rowGroupModel, ICellPainter interiorPainter) {
        this.rowGroupModel = rowGroupModel;
        this.setWrappedPainter(new CellPainterDecorator(interiorPainter, CellEdgeEnum.BOTTOM, new ExpandCollapseImagePainter()));
    }

    @Override
    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return 0;
    }

    public class ExpandCollapseImagePainter
    extends ImagePainter {
        final Image downImg;
        final Image upImg;

        public ExpandCollapseImagePainter() {
            super(null, true);
            this.downImg = GUIHelper.getImage("down_0");
            this.upImg = GUIHelper.getImage("up_0");
        }

        @Override
        protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
            IRowGroup rowGroup = RowGroupUtils.getTopMostParentGroup(RowGroupUtils.getRowGroupForRowIndex(RowGroupHeaderTextPainter.this.rowGroupModel, cell.getRowIndex()));
            if (rowGroup != null) {
                return rowGroup.isCollapsed() ? this.downImg : this.upImg;
            }
            return null;
        }
    }
}

