/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.nebula.widgets.nattable.group.RowGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.config.DefaultRowGroupHeaderLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.group.model.IRowGroup;
import org.eclipse.nebula.widgets.nattable.group.model.IRowGroupModel;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.SizeConfig;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.LayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnStructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.painter.layer.CellLayerPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.selection.SelectRowGroupCommandHandler;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class RowGroupHeaderLayer<T>
extends AbstractLayerTransform {
    private final SizeConfig columnWidthConfig = new SizeConfig(100);
    private final IRowGroupModel<T> model;
    private final SelectionLayer selectionLayer;
    private final ILayer rowHeaderLayer;
    private final ILayerPainter layerPainter = new CellLayerPainter();

    public RowGroupHeaderLayer(ILayer rowHeaderLayer, SelectionLayer selectionLayer, IRowGroupModel<T> rowGroupModel) {
        this(rowHeaderLayer, selectionLayer, rowGroupModel, true);
    }

    public RowGroupHeaderLayer(ILayer rowHeaderLayer, SelectionLayer selectionLayer, IRowGroupModel<T> rowGroupModel, boolean useDefaultConfiguration) {
        super(rowHeaderLayer);
        this.rowHeaderLayer = rowHeaderLayer;
        this.selectionLayer = selectionLayer;
        this.model = rowGroupModel;
        this.registerCommandHandlers();
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultRowGroupHeaderLayerConfiguration<T>(rowGroupModel));
        }
    }

    public IRowGroupModel<T> getModel() {
        return this.model;
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        super.loadState(prefix, properties);
        this.model.loadState(prefix, properties);
        this.fireLayerEvent(new ColumnStructuralRefreshEvent(this));
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        super.saveState(prefix, properties);
        this.model.saveState(prefix, properties);
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new SelectRowGroupCommandHandler<T>(this.model, this.selectionLayer, this));
    }

    @Override
    public ILayerPainter getLayerPainter() {
        return this.layerPainter;
    }

    @Override
    public int getColumnCount() {
        return this.rowHeaderLayer.getColumnCount() + 1;
    }

    @Override
    public int getPreferredColumnCount() {
        return this.rowHeaderLayer.getPreferredColumnCount() + 1;
    }

    @Override
    public int getColumnIndexByPosition(int columnPosition) {
        if (columnPosition == 0) {
            return columnPosition;
        }
        return this.rowHeaderLayer.getColumnIndexByPosition(columnPosition - 1);
    }

    @Override
    public int getWidth() {
        return this.columnWidthConfig.getAggregateSize(1) + this.rowHeaderLayer.getWidth();
    }

    @Override
    public int getPreferredWidth() {
        return this.columnWidthConfig.getAggregateSize(1) + this.rowHeaderLayer.getPreferredWidth();
    }

    @Override
    public int getColumnWidthByPosition(int columnPosition) {
        if (columnPosition == 0) {
            return this.columnWidthConfig.getSize(columnPosition);
        }
        return this.rowHeaderLayer.getColumnWidthByPosition(columnPosition - 1);
    }

    public void setColumnWidth(int columnWidth) {
        this.columnWidthConfig.setSize(0, columnWidth);
    }

    @Override
    public boolean isColumnPositionResizable(int columnPosition) {
        if (columnPosition == 0) {
            return this.columnWidthConfig.isPositionResizable(columnPosition);
        }
        return this.rowHeaderLayer.isRowPositionResizable(columnPosition - 1);
    }

    @Override
    public int getColumnPositionByX(int x) {
        int col0Width = this.getColumnWidthByPosition(0);
        if (x < col0Width) {
            return 0;
        }
        return 1 + this.rowHeaderLayer.getColumnPositionByX(x - col0Width);
    }

    @Override
    public int getStartXOfColumnPosition(int columnPosition) {
        if (columnPosition == 0) {
            return this.columnWidthConfig.getAggregateSize(columnPosition);
        }
        return this.getColumnWidthByPosition(0) + this.rowHeaderLayer.getStartXOfColumnPosition(columnPosition - 1);
    }

    @Override
    public ILayerCell getCellByPosition(int columnPosition, int rowPosition) {
        int bodyRowIndex = this.getRowIndexByPosition(rowPosition);
        if (RowGroupUtils.isPartOfAGroup(this.model, bodyRowIndex) && columnPosition == 0) {
            return new LayerCell(this, columnPosition, this.getStartPositionOfGroup(rowPosition), columnPosition, rowPosition, 1, this.getRowSpan(rowPosition));
        }
        return new LayerCell(this, columnPosition, rowPosition);
    }

    protected int getRowSpan(int rowPosition) {
        int rowIndex = this.getRowIndexByPosition(rowPosition);
        IRowGroup<T> rowGroup = RowGroupUtils.getRowGroupForRowIndex(this.model, rowIndex);
        if (RowGroupUtils.isCollapsed(this.model, rowGroup)) {
            return rowGroup.getOwnStaticMemberRows().size();
        }
        int startPositionOfGroup = this.getStartPositionOfGroup(rowPosition);
        int sizeOfGroup = RowGroupUtils.sizeOfGroup(this.model, rowIndex);
        int endPositionOfGroup = startPositionOfGroup + sizeOfGroup;
        List<Integer> rowIndexesInGroup = RowGroupUtils.getRowIndexesInGroup(this.model, rowIndex);
        int i = startPositionOfGroup;
        while (i < endPositionOfGroup) {
            int index = this.getRowIndexByPosition(i);
            if (!rowIndexesInGroup.contains(index)) {
                --sizeOfGroup;
            }
            ++i;
        }
        return Math.max(1, sizeOfGroup);
    }

    private int getStartPositionOfGroup(int rowPosition) {
        int bodyRowIndex = this.getRowIndexByPosition(rowPosition);
        int leastPossibleStartPositionOfGroup = Math.max(0, rowPosition - RowGroupUtils.sizeOfGroup(this.model, bodyRowIndex));
        int i = 0;
        i = leastPossibleStartPositionOfGroup;
        while (i < rowPosition) {
            if (RowGroupUtils.isInTheSameGroup(this.getRowIndexByPosition(i), bodyRowIndex, this.model)) break;
            ++i;
        }
        return i;
    }

    @Override
    public String getDisplayModeByPosition(int columnPosition, int rowPosition) {
        int rowIndex = this.getRowIndexByPosition(rowPosition);
        if (columnPosition == 0 && RowGroupUtils.isPartOfAGroup(this.model, rowIndex)) {
            return "NORMAL";
        }
        return this.rowHeaderLayer.getDisplayModeByPosition(columnPosition - 1, rowPosition);
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        int rowIndex = this.getRowIndexByPosition(rowPosition);
        if (columnPosition == 0 && RowGroupUtils.isPartOfAGroup(this.model, rowIndex)) {
            List<Integer> selectedRowIndexes = this.convertToRowIndexes(this.selectionLayer.getFullySelectedRowPositions());
            if (selectedRowIndexes.contains(rowIndex)) {
                return new LabelStack("ROW_HEADER_FULL", "ROW_GROUP_HEADER");
            }
            return new LabelStack("ROW_GROUP_HEADER");
        }
        return this.rowHeaderLayer.getConfigLabelsByPosition(columnPosition - 1, rowPosition);
    }

    private List<Integer> convertToRowIndexes(int[] rowPositions) {
        ArrayList<Integer> rowIndexes = new ArrayList<Integer>();
        int[] nArray = rowPositions;
        int n = rowPositions.length;
        int n2 = 0;
        while (n2 < n) {
            Integer rowPosition = nArray[n2];
            rowIndexes.add(this.selectionLayer.getRowIndexByPosition(rowPosition));
            ++n2;
        }
        return rowIndexes;
    }

    @Override
    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        int rowIndex = this.getRowIndexByPosition(rowPosition);
        if (columnPosition == 0) {
            if (RowGroupUtils.isPartOfAGroup(this.model, rowIndex)) {
                return RowGroupUtils.getRowGroupNameForIndex(this.model, rowIndex);
            }
            return null;
        }
        return this.rowHeaderLayer.getDataValueByPosition(columnPosition - 1, rowPosition);
    }

    @Override
    public LabelStack getRegionLabelsByXY(int x, int y) {
        int rowIndex = this.getRowIndexByPosition(this.getRowPositionByY(y));
        if (RowGroupUtils.isPartOfAGroup(this.model, rowIndex) && x < this.getColumnWidthByPosition(0)) {
            return new LabelStack("ROW_GROUP_HEADER");
        }
        return this.rowHeaderLayer.getRegionLabelsByXY(x - this.getColumnWidthByPosition(0), y);
    }

    public void collapseRowGroupByIndex(int rowIndex) {
        RowGroupUtils.getRowGroupForRowIndex(this.model, rowIndex).collapse();
    }

    public void clearAllGroups() {
        this.model.clear();
    }
}

