/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.nebula.widgets.nattable.group.IColumnGroupModelListener;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

public class ColumnGroupModel
implements IPersistable {
    private static final String PERSISTENCE_KEY_COLUMN_GROUPS = ".columnGroups";
    private final List<ColumnGroup> columnGroups = new LinkedList<ColumnGroup>();
    private final Collection<IColumnGroupModelListener> listeners = new HashSet<IColumnGroupModelListener>();

    public void registerColumnGroupModelListener(IColumnGroupModelListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterColumnGroupModelListener(IColumnGroupModelListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyListeners() {
        for (IColumnGroupModelListener listener : this.listeners) {
            listener.columnGroupModelChanged();
        }
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        StringBuilder strBuilder = new StringBuilder();
        for (ColumnGroup columnGroup : this.columnGroups) {
            String columnGroupName = columnGroup.getName();
            if (columnGroup.members.size() == 0) continue;
            strBuilder.append(columnGroupName);
            strBuilder.append('=');
            strBuilder.append(columnGroup.collapsed ? "collapsed" : "expanded");
            strBuilder.append(':');
            strBuilder.append(columnGroup.collapseable ? "collapseable" : "uncollapseable");
            strBuilder.append(':');
            strBuilder.append(columnGroup.unbreakable ? "unbreakable" : "breakable");
            strBuilder.append(':');
            for (Integer member : columnGroup.members) {
                strBuilder.append(member);
                strBuilder.append(',');
            }
            strBuilder.append('|');
        }
        properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_COLUMN_GROUPS, strBuilder.toString());
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        String property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_COLUMN_GROUPS);
        if (property != null) {
            this.clear();
            StringTokenizer columnGroupTokenizer = new StringTokenizer(property, "|");
            while (columnGroupTokenizer.hasMoreTokens()) {
                String columnGroupToken = columnGroupTokenizer.nextToken();
                int separatorIndex = columnGroupToken.indexOf(61);
                String columnGroupName = columnGroupToken.substring(0, separatorIndex);
                ColumnGroup columnGroup = new ColumnGroup(columnGroupName);
                this.columnGroups.add(columnGroup);
                String[] columnGroupProperties = columnGroupToken.substring(separatorIndex + 1).split(":");
                String state = columnGroupProperties[0];
                if ("collapsed".equals(state)) {
                    columnGroup.collapsed = true;
                } else if ("expanded".equals(state)) {
                    columnGroup.collapsed = false;
                } else {
                    throw new IllegalArgumentException(String.valueOf(state) + " not one of 'expanded' or 'collapsed'");
                }
                state = columnGroupProperties[1];
                if ("collapseable".equals(state)) {
                    columnGroup.collapseable = true;
                } else if ("uncollapseable".equals(state)) {
                    columnGroup.collapseable = false;
                } else {
                    throw new IllegalArgumentException(String.valueOf(state) + " not one of 'uncollapseable' or 'collapseable'");
                }
                state = columnGroupProperties[2];
                if ("breakable".equals(state)) {
                    columnGroup.unbreakable = false;
                } else if ("unbreakable".equals(state)) {
                    columnGroup.unbreakable = true;
                } else {
                    throw new IllegalArgumentException(String.valueOf(state) + " not one of 'breakable' or 'unbreakable'");
                }
                String indexes = columnGroupProperties[3];
                StringTokenizer indexTokenizer = new StringTokenizer(indexes, ",");
                while (indexTokenizer.hasMoreTokens()) {
                    Integer index = Integer.valueOf(indexTokenizer.nextToken());
                    columnGroup.members.add(index);
                }
            }
        }
    }

    public void addColumnsIndexesToGroup(String colGroupName, int ... bodyColumnIndexs) {
        if (this.getColumnGroupByName(colGroupName) == null) {
            ColumnGroup group = new ColumnGroup(colGroupName);
            this.columnGroups.add(group);
        }
        this.insertColumnIndexes(colGroupName, bodyColumnIndexs);
        this.notifyListeners();
    }

    public boolean insertColumnIndexes(String colGroupName, int ... columnIndexesToInsert) {
        LinkedList<Integer> members = new LinkedList<Integer>();
        ColumnGroup columnGroup = this.getColumnGroupByName(colGroupName);
        if (columnGroup.unbreakable) {
            return false;
        }
        int[] nArray = columnIndexesToInsert;
        int n = columnIndexesToInsert.length;
        int n2 = 0;
        while (n2 < n) {
            int columnIndexToInsert = nArray[n2];
            Integer index = columnIndexToInsert;
            if (this.getColumnGroupByIndex(columnIndexToInsert) != null) {
                return false;
            }
            members.add(index);
            ++n2;
        }
        columnGroup.members.addAll(members);
        this.notifyListeners();
        return true;
    }

    public void setStaticColumnIndexesByGroup(String colGroupName, int[] staticColumnIndexes) {
        if (this.getColumnGroupByName(colGroupName) == null) {
            ColumnGroup group = new ColumnGroup(colGroupName);
            this.columnGroups.add(group);
        }
        this.insertStaticColumnIndexes(colGroupName, staticColumnIndexes);
        this.notifyListeners();
    }

    public void insertStaticColumnIndexes(String colGroupName, int ... columnIndexesToInsert) {
        LinkedList<Integer> staticColumnIndexes = new LinkedList<Integer>();
        ColumnGroup columnGroup = this.getColumnGroupByName(colGroupName);
        int[] nArray = columnIndexesToInsert;
        int n = columnIndexesToInsert.length;
        int n2 = 0;
        while (n2 < n) {
            int columnIndexToInsert = nArray[n2];
            Integer index = columnIndexToInsert;
            staticColumnIndexes.add(index);
            ++n2;
        }
        columnGroup.staticColumnIndexes.addAll(staticColumnIndexes);
        this.notifyListeners();
    }

    public ColumnGroup getColumnGroupByName(String groupName) {
        for (ColumnGroup columnGroup : this.columnGroups) {
            if (!columnGroup.getName().equals(groupName)) continue;
            return columnGroup;
        }
        return null;
    }

    public ColumnGroup getColumnGroupByIndex(int columnIndex) {
        for (ColumnGroup columnGroup : this.columnGroups) {
            if (!columnGroup.getMembers().contains(columnIndex)) continue;
            return columnGroup;
        }
        return null;
    }

    public void addColumnGroup(ColumnGroup columnGroup) {
        this.columnGroups.add(columnGroup);
        this.notifyListeners();
    }

    public void removeColumnGroup(ColumnGroup columnGroup) {
        this.columnGroups.remove(columnGroup);
        this.notifyListeners();
    }

    public boolean isPartOfAGroup(int bodyColumnIndex) {
        for (ColumnGroup columnGroup : this.columnGroups) {
            if (!columnGroup.members.contains(bodyColumnIndex)) continue;
            return true;
        }
        return false;
    }

    public boolean isAGroup(String cellValue) {
        for (ColumnGroup columnGroup : this.columnGroups) {
            if (!columnGroup.getName().equals(cellValue)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.columnGroups.clear();
    }

    public int size() {
        return this.columnGroups.size();
    }

    public boolean isEmpty() {
        return this.columnGroups.size() == 0;
    }

    public List<Integer> getAllIndexesInGroups() {
        LinkedList<Integer> indexes = new LinkedList<Integer>();
        for (ColumnGroup columnGroup : this.columnGroups) {
            indexes.addAll(columnGroup.members);
        }
        return indexes;
    }

    public boolean isStaticColumn(int bodyColumnIndex) {
        if (this.isPartOfAGroup(bodyColumnIndex)) {
            return this.getColumnGroupByIndex(bodyColumnIndex).staticColumnIndexes.contains(bodyColumnIndex);
        }
        return false;
    }

    public int getCollapsedColumnCount() {
        int count = 0;
        for (ColumnGroup columnGroup : this.columnGroups) {
            if (!columnGroup.collapsed) continue;
            int staticColumnIndexesCount = columnGroup.getStaticColumnIndexes().size();
            count = count + columnGroup.getMembers().size() - Math.max(staticColumnIndexesCount, 1);
        }
        return count;
    }

    public int getColumnGroupPositionFromIndex(int bodyColumnIndex) {
        if (this.isPartOfAGroup(bodyColumnIndex)) {
            ColumnGroup columnGroup = this.getColumnGroupByIndex(bodyColumnIndex);
            return columnGroup.members.indexOf(bodyColumnIndex);
        }
        return -1;
    }

    public boolean isPartOfACollapseableGroup(int columnIndex) {
        if (this.isPartOfAGroup(columnIndex)) {
            return this.getColumnGroupByIndex(columnIndex).isCollapseable();
        }
        return false;
    }

    public void setColumnGroupCollapseable(int columnIndex, boolean collabseable) {
        if (this.isPartOfAGroup(columnIndex)) {
            this.getColumnGroupByIndex(columnIndex).setCollapseable(collabseable);
        }
    }

    public boolean isPartOfAnUnbreakableGroup(int columnIndex) {
        if (this.isPartOfAGroup(columnIndex)) {
            return this.getColumnGroupByIndex(columnIndex).isUnbreakable();
        }
        return false;
    }

    public void setColumnGroupUnbreakable(int columnIndex, boolean unbreakable) {
        if (this.isPartOfAGroup(columnIndex)) {
            this.getColumnGroupByIndex(columnIndex).setUnbreakable(unbreakable);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Column Group Model:\n");
        for (ColumnGroup columnGroup : this.columnGroups) {
            buffer.append(columnGroup);
        }
        return buffer.toString();
    }

    public class ColumnGroup {
        private final LinkedList<Integer> members = new LinkedList();
        private LinkedList<Integer> staticColumnIndexes = new LinkedList();
        private String name;
        private boolean collapsed = false;
        private boolean collapseable = true;
        private boolean unbreakable = false;

        ColumnGroup(String groupName) {
            this.name = groupName;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            ColumnGroupModel.this.notifyListeners();
        }

        public boolean isCollapsed() {
            return this.collapsed;
        }

        public void setCollapsed(boolean collapsed) {
            this.collapsed = collapsed;
            ColumnGroupModel.this.notifyListeners();
        }

        public void toggleCollapsed() {
            this.setCollapsed(!this.collapsed);
        }

        public boolean isCollapseable() {
            return this.collapseable;
        }

        public void setCollapseable(boolean collapseable) {
            this.collapseable = collapseable;
            ColumnGroupModel.this.notifyListeners();
        }

        public boolean isUnbreakable() {
            return this.unbreakable;
        }

        public void setUnbreakable(boolean unbreakable) {
            this.unbreakable = unbreakable;
            ColumnGroupModel.this.notifyListeners();
        }

        public List<Integer> getMembers() {
            return this.members;
        }

        public List<Integer> getMembersSorted() {
            List<Integer> sortedMembers = Collections.unmodifiableList(this.members);
            Collections.sort(sortedMembers);
            return sortedMembers;
        }

        public LinkedList<Integer> getStaticColumnIndexes() {
            return this.staticColumnIndexes;
        }

        public int getSize() {
            return this.members.size();
        }

        public boolean removeColumn(int bodyColumnIndex) {
            if (this.members.contains(bodyColumnIndex) && !this.unbreakable) {
                this.members.remove((Object)bodyColumnIndex);
                if (this.members.size() == 0) {
                    ColumnGroupModel.this.columnGroups.remove(this);
                }
                ColumnGroupModel.this.notifyListeners();
                return true;
            }
            return false;
        }

        public String toString() {
            return "Column Group:\n\t name: " + this.name + "\n\t collapsed: " + this.collapsed + "\n\t unbreakable: " + this.unbreakable + "\n\t members: " + ObjectUtils.toString(this.members) + "\n" + "\n\t staticColumns: " + ObjectUtils.toString(this.staticColumnIndexes) + "\n";
        }
    }
}

