/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.IColumnGroupModelListener;
import org.eclipse.nebula.widgets.nattable.group.command.ColumnGroupExpandCollapseCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.AbstractColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;

public class ColumnGroupExpandCollapseLayer
extends AbstractColumnHideShowLayer
implements IColumnGroupModelListener {
    private final ColumnGroupModel model;

    public ColumnGroupExpandCollapseLayer(IUniqueIndexLayer underlyingLayer, ColumnGroupModel model) {
        super(underlyingLayer);
        this.model = model;
        model.registerColumnGroupModelListener(this);
        this.registerCommandHandler(new ColumnGroupExpandCollapseCommandHandler(this));
    }

    public ColumnGroupModel getModel() {
        return this.model;
    }

    @Override
    public boolean isColumnIndexHidden(int columnIndex) {
        boolean isCollapsedAndStaticColumn;
        IUniqueIndexLayer underlyingLayer = (IUniqueIndexLayer)this.getUnderlyingLayer();
        boolean isHiddeninUnderlyingLayer = ColumnGroupUtils.isColumnIndexHiddenInUnderLyingLayer(columnIndex, this, underlyingLayer);
        ColumnGroupModel.ColumnGroup columnGroup = this.model.getColumnGroupByIndex(columnIndex);
        boolean bl = isCollapsedAndStaticColumn = columnGroup != null && columnGroup.isCollapsed() && !ColumnGroupUtils.isStaticOrFirstVisibleColumn(columnIndex, underlyingLayer, underlyingLayer, this.model);
        return isHiddeninUnderlyingLayer || isCollapsedAndStaticColumn;
    }

    @Override
    public Collection<Integer> getHiddenColumnIndexes() {
        HashSet<Integer> hiddenColumnIndexes = new HashSet<Integer>();
        IUniqueIndexLayer underlyingLayer = (IUniqueIndexLayer)this.getUnderlyingLayer();
        int underlyingColumnCount = underlyingLayer.getColumnCount();
        int i = 0;
        while (i < underlyingColumnCount) {
            int columnIndex = underlyingLayer.getColumnIndexByPosition(i);
            ColumnGroupModel.ColumnGroup columnGroup = this.model.getColumnGroupByIndex(columnIndex);
            if (columnGroup != null && columnGroup.isCollapsed() && !ColumnGroupUtils.isStaticOrFirstVisibleColumn(columnIndex, underlyingLayer, underlyingLayer, this.model)) {
                hiddenColumnIndexes.add(columnIndex);
            }
            ++i;
        }
        return hiddenColumnIndexes;
    }

    @Override
    public void columnGroupModelChanged() {
        this.invalidateCache();
    }
}

