/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow.combobox;

import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.TextMatchingMode;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.ComboBoxFilterIconPainter;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.filterrow.config.FilterRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.painter.cell.ImagePainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;

public class ComboBoxFilterRowConfiguration
extends AbstractRegistryConfiguration {
    protected ICellEditor cellEditor;
    protected ImagePainter filterIconPainter;

    public ComboBoxFilterRowConfiguration() {
    }

    public ComboBoxFilterRowConfiguration(IComboBoxDataProvider comboBoxDataProvider) {
        this.cellEditor = new FilterRowComboBoxCellEditor(comboBoxDataProvider, 10);
        this.filterIconPainter = new ComboBoxFilterIconPainter(comboBoxDataProvider);
    }

    @Override
    public void configureRegistry(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, this.cellEditor, "NORMAL", "FILTER_ROW");
        configRegistry.registerConfigAttribute(FilterRowConfigAttributes.TEXT_MATCHING_MODE, TextMatchingMode.REGULAR_EXPRESSION);
        CellPainterDecorator cellPainter = new CellPainterDecorator(new TextPainter(){
            {
                this.paintFg = false;
            }
        }, CellEdgeEnum.RIGHT, this.filterIconPainter);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, cellPainter, "NORMAL", "FILTER_ROW");
    }
}

