/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.editor;

import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.config.RenderErrorHandling;
import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.ControlDecorationProvider;
import org.eclipse.nebula.widgets.nattable.edit.editor.EditorSelectionEnum;
import org.eclipse.nebula.widgets.nattable.edit.editor.IEditErrorHandler;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class TextCellEditor
extends AbstractCellEditor {
    private Text text = null;
    private boolean editable = true;
    private final boolean commitOnUpDown;
    private final boolean moveSelectionOnEnter;
    private EditorSelectionEnum selectionMode;
    protected final ControlDecorationProvider decorationProvider = new ControlDecorationProvider();
    private IEditErrorHandler inputConversionErrorHandler = new RenderErrorHandling(this.decorationProvider);
    private IEditErrorHandler inputValidationErrorHandler = new RenderErrorHandling(this.decorationProvider);
    protected boolean commitOnEnter = true;

    public TextCellEditor() {
        this(false);
    }

    public TextCellEditor(boolean commitOnUpDown) {
        this(commitOnUpDown, false);
    }

    public TextCellEditor(boolean commitOnUpDown, boolean moveSelectionOnEnter) {
        this.commitOnUpDown = commitOnUpDown;
        this.moveSelectionOnEnter = moveSelectionOnEnter;
    }

    @Override
    protected Control activateCell(Composite parent, Object originalCanonicalValue) {
        this.text = this.createEditorControl(parent);
        if (originalCanonicalValue instanceof Character) {
            this.text.setText(originalCanonicalValue.toString());
            this.selectText(this.selectionMode != null ? this.selectionMode : EditorSelectionEnum.END);
        } else {
            this.setCanonicalValue(originalCanonicalValue);
            this.selectText(this.selectionMode != null ? this.selectionMode : EditorSelectionEnum.ALL);
        }
        if (!this.isEditable()) {
            this.text.setEditable(false);
        }
        this.decorationProvider.createErrorDecorationIfRequired((Control)this.text);
        if (this.inputConversionErrorHandler instanceof RenderErrorHandling) {
            IStyle conversionErrorStyle = this.configRegistry.getConfigAttribute(EditConfigAttributes.CONVERSION_ERROR_STYLE, "EDIT", this.labelStack.getLabels());
            ((RenderErrorHandling)this.inputConversionErrorHandler).setErrorStyle(conversionErrorStyle);
        }
        if (this.inputValidationErrorHandler instanceof RenderErrorHandling) {
            IStyle validationErrorStyle = this.configRegistry.getConfigAttribute(EditConfigAttributes.VALIDATION_ERROR_STYLE, "EDIT", this.labelStack.getLabels());
            ((RenderErrorHandling)this.inputValidationErrorHandler).setErrorStyle(validationErrorStyle);
        }
        this.text.forceFocus();
        return this.text;
    }

    @Override
    public String getEditorValue() {
        return this.text.getText();
    }

    @Override
    public void setEditorValue(Object value) {
        this.text.setText(value != null && value.toString().length() > 0 ? value.toString() : "");
    }

    public Text getEditorControl() {
        return this.text;
    }

    public Text createEditorControl(Composite parent) {
        int style = HorizontalAlignmentEnum.getSWTStyle(this.cellStyle);
        if (this.editMode == EditModeEnum.DIALOG) {
            style |= 0x800;
        }
        return this.createEditorControl(parent, style);
    }

    protected Text createEditorControl(final Composite parent, int style) {
        Text textControl = new Text(parent, style);
        textControl.setBackground(this.cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
        textControl.setForeground(this.cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR));
        textControl.setFont(this.cellStyle.getAttributeValue(CellStyleAttributes.FONT));
        textControl.setCursor(new Cursor((Device)Display.getDefault(), 19));
        textControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (TextCellEditor.this.commitOnEnter && (event.keyCode == 13 || event.keyCode == 0x1000050)) {
                    SelectionLayer.MoveDirectionEnum move = SelectionLayer.MoveDirectionEnum.NONE;
                    if (TextCellEditor.this.moveSelectionOnEnter && TextCellEditor.this.editMode == EditModeEnum.INLINE) {
                        if (event.stateMask == 0) {
                            move = SelectionLayer.MoveDirectionEnum.DOWN;
                        } else if (event.stateMask == 131072) {
                            move = SelectionLayer.MoveDirectionEnum.UP;
                        }
                    }
                    TextCellEditor.this.commit(move);
                    if (TextCellEditor.this.editMode == EditModeEnum.DIALOG) {
                        parent.forceFocus();
                    }
                } else if (event.keyCode == 27 && event.stateMask == 0) {
                    TextCellEditor.this.close();
                } else if (TextCellEditor.this.commitOnUpDown && TextCellEditor.this.editMode == EditModeEnum.INLINE) {
                    if (event.keyCode == 0x1000001) {
                        TextCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.UP);
                    } else if (event.keyCode == 0x1000002) {
                        TextCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.DOWN);
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
                try {
                    Object canonicalValue = TextCellEditor.this.getCanonicalValue(TextCellEditor.this.inputConversionErrorHandler);
                    TextCellEditor.this.validateCanonicalValue(canonicalValue, TextCellEditor.this.inputValidationErrorHandler);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return textControl;
    }

    @Override
    public void close() {
        super.close();
        this.decorationProvider.dispose();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public final EditorSelectionEnum getSelectionMode() {
        return this.selectionMode;
    }

    public final void setSelectionMode(EditorSelectionEnum selectionMode) {
        this.selectionMode = selectionMode;
    }

    private void selectText(EditorSelectionEnum selectionMode) {
        int textLength = this.text.getText().length();
        if (textLength > 0) {
            if (selectionMode == EditorSelectionEnum.ALL) {
                this.text.setSelection(0, textLength);
            } else if (selectionMode == EditorSelectionEnum.END) {
                this.text.setSelection(textLength, textLength);
            } else if (selectionMode == EditorSelectionEnum.START) {
                this.text.setSelection(0);
            }
        }
    }

    public ControlDecorationProvider getDecorationProvider() {
        return this.decorationProvider;
    }

    public void setErrorDecorationEnabled(boolean enabled) {
        this.decorationProvider.setErrorDecorationEnabled(enabled);
    }

    public void setErrorDecorationText(String errorText) {
        this.decorationProvider.setErrorDecorationText(errorText);
    }

    public void showErrorDecorationHover(String customErrorText) {
        this.decorationProvider.showErrorDecorationHover(customErrorText);
    }

    public void setDecorationPositionOverride(int decorationPositionOverride) {
        this.decorationProvider.setDecorationPositionOverride(decorationPositionOverride);
    }

    public IEditErrorHandler getInputConversionErrorHandler() {
        return this.inputConversionErrorHandler;
    }

    public void setInputConversionErrorHandler(IEditErrorHandler inputConversionErrorHandler) {
        this.inputConversionErrorHandler = inputConversionErrorHandler;
    }

    public IEditErrorHandler getInputValidationErrorHandler() {
        return this.inputValidationErrorHandler;
    }

    public void setInputValidationErrorHandler(IEditErrorHandler inputValidationErrorHandler) {
        this.inputValidationErrorHandler = inputValidationErrorHandler;
    }
}

