/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.editor;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractCellEditor;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CheckBoxCellEditor
extends AbstractCellEditor {
    private boolean checked;
    private Canvas canvas;

    @Override
    protected Control activateCell(Composite parent, Object originalCanonicalValue) {
        if (originalCanonicalValue instanceof Character) {
            return null;
        }
        this.setCanonicalValue(originalCanonicalValue);
        this.checked = !this.checked;
        this.canvas = this.createEditorControl(parent);
        this.commit(SelectionLayer.MoveDirectionEnum.NONE, false);
        if (this.editMode == EditModeEnum.INLINE && this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CheckBoxCellEditor.this.close();
                }
            });
        }
        return this.canvas;
    }

    @Override
    public Boolean getEditorValue() {
        return this.checked;
    }

    @Override
    public void setEditorValue(Object value) {
        this.checked = value == null ? false : (value instanceof Boolean ? (Boolean)value : (value instanceof String ? Boolean.valueOf((String)value) : false));
    }

    public Canvas getEditorControl() {
        return this.canvas;
    }

    public Canvas createEditorControl(Composite parent) {
        final Canvas canvas = new Canvas(parent, 0);
        canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CheckBoxCellEditor.this.checked = !CheckBoxCellEditor.this.checked;
                canvas.redraw();
            }
        });
        return canvas;
    }

    @Override
    public boolean supportMultiEdit(IConfigRegistry configRegistry, List<String> configLabels) {
        return false;
    }

    @Override
    public boolean activateAtAnyPosition() {
        return false;
    }
}

