/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.editor;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.ConversionFailedException;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.data.validate.ValidationFailedException;
import org.eclipse.nebula.widgets.nattable.edit.ActiveCellEditorRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigHelper;
import org.eclipse.nebula.widgets.nattable.edit.ICellEditHandler;
import org.eclipse.nebula.widgets.nattable.edit.command.EditSelectionCommand;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IEditErrorHandler;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleProxy;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractCellEditor
implements ICellEditor {
    private static final Log log = LogFactory.getLog(AbstractCellEditor.class);
    private boolean closed;
    private Composite parent;
    private ICellEditHandler editHandler;
    protected IStyle cellStyle;
    protected IDisplayConverter displayConverter;
    protected IDataValidator dataValidator;
    protected EditModeEnum editMode;
    protected ILayerCell layerCell;
    protected LabelStack labelStack;
    protected IEditErrorHandler conversionEditErrorHandler;
    protected IEditErrorHandler validationEditErrorHandler;
    protected IConfigRegistry configRegistry;
    private FocusListener focusListener = new InlineFocusListener();
    private TraverseListener traverseListener = new InlineTraverseListener();

    @Override
    public final Control activateCell(Composite parent, Object originalCanonicalValue, EditModeEnum editMode, ICellEditHandler editHandler, ILayerCell cell, IConfigRegistry configRegistry) {
        this.closed = false;
        this.parent = parent;
        this.editHandler = editHandler;
        this.editMode = editMode;
        this.layerCell = cell;
        this.configRegistry = configRegistry;
        this.labelStack = cell.getConfigLabels();
        List<String> configLabels = this.labelStack.getLabels();
        this.displayConverter = configRegistry.getConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, "EDIT", configLabels);
        this.cellStyle = new CellStyleProxy(configRegistry, "EDIT", configLabels);
        this.dataValidator = configRegistry.getConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, "EDIT", configLabels);
        this.conversionEditErrorHandler = EditConfigHelper.getEditErrorHandler(configRegistry, EditConfigAttributes.CONVERSION_ERROR_HANDLER, configLabels);
        this.validationEditErrorHandler = EditConfigHelper.getEditErrorHandler(configRegistry, EditConfigAttributes.VALIDATION_ERROR_HANDLER, configLabels);
        return this.activateCell(parent, originalCanonicalValue);
    }

    protected abstract Control activateCell(Composite var1, Object var2);

    @Override
    public int getColumnIndex() {
        return this.layerCell.getColumnIndex();
    }

    @Override
    public int getRowIndex() {
        return this.layerCell.getRowIndex();
    }

    @Override
    public int getColumnPosition() {
        return this.layerCell.getColumnPosition();
    }

    @Override
    public int getRowPosition() {
        return this.layerCell.getRowPosition();
    }

    @Override
    public Object getCanonicalValue() {
        return this.getCanonicalValue(this.conversionEditErrorHandler);
    }

    @Override
    public Object getCanonicalValue(IEditErrorHandler conversionErrorHandler) {
        return this.handleConversion(this.getEditorValue(), conversionErrorHandler);
    }

    protected Object handleConversion(Object displayValue, IEditErrorHandler conversionErrorHandler) {
        Object canonicalValue;
        try {
            canonicalValue = this.displayConverter != null ? this.displayConverter.displayToCanonicalValue(this.layerCell, this.configRegistry, displayValue) : displayValue;
            conversionErrorHandler.removeError(this);
        }
        catch (ConversionFailedException e) {
            conversionErrorHandler.displayError(this, e);
            throw e;
        }
        catch (Exception e) {
            conversionErrorHandler.displayError(this, e);
            throw new ConversionFailedException(e.getMessage(), e);
        }
        return canonicalValue;
    }

    @Override
    public void setCanonicalValue(Object canonicalValue) {
        Object displayValue = this.displayConverter != null ? this.displayConverter.canonicalToDisplayValue(this.layerCell, this.configRegistry, canonicalValue) : canonicalValue;
        this.setEditorValue(displayValue);
    }

    @Override
    public boolean validateCanonicalValue(Object canonicalValue) {
        return this.validateCanonicalValue(canonicalValue, this.validationEditErrorHandler);
    }

    @Override
    public boolean validateCanonicalValue(Object canonicalValue, IEditErrorHandler validationEditErrorHandler) {
        if (this.dataValidator != null) {
            try {
                boolean validationResult = this.dataValidator.validate(this.layerCell, this.configRegistry, canonicalValue);
                if (!validationResult) {
                    throw new ValidationFailedException(Messages.getString("AbstractCellEditor.validationFailure"));
                }
                validationEditErrorHandler.removeError(this);
                return validationResult;
            }
            catch (Exception e) {
                validationEditErrorHandler.displayError(this, e);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean commit(SelectionLayer.MoveDirectionEnum direction) {
        return this.commit(direction, true);
    }

    @Override
    public boolean commit(SelectionLayer.MoveDirectionEnum direction, boolean closeAfterCommit) {
        return this.commit(direction, closeAfterCommit, false);
    }

    @Override
    public boolean commit(SelectionLayer.MoveDirectionEnum direction, boolean closeAfterCommit, boolean skipValidation) {
        if (this.editHandler != null && !this.closed) {
            try {
                Object canonicalValue = this.getCanonicalValue();
                if (skipValidation || !skipValidation && this.validateCanonicalValue(canonicalValue)) {
                    boolean committed = this.editHandler.commit(canonicalValue, direction);
                    if (committed && closeAfterCommit) {
                        this.close();
                        if (direction != SelectionLayer.MoveDirectionEnum.NONE && this.openAdjacentEditor()) {
                            this.layerCell.getLayer().doCommand(new EditSelectionCommand(this.parent, this.configRegistry));
                        }
                    }
                    return committed;
                }
            }
            catch (ConversionFailedException canonicalValue) {
            }
            catch (ValidationFailedException canonicalValue) {
            }
            catch (Exception e) {
                log.error((Object)("Error on updating cell value: " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.forceFocus();
        }
        this.removeEditorControlListeners();
        Control editorControl = this.getEditorControl();
        if (editorControl != null && !editorControl.isDisposed()) {
            editorControl.dispose();
        }
        ActiveCellEditorRegistry.unregisterActiveCellEditor();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean openInline(IConfigRegistry configRegistry, List<String> configLabels) {
        return EditConfigHelper.openInline(configRegistry, configLabels);
    }

    @Override
    public boolean supportMultiEdit(IConfigRegistry configRegistry, List<String> configLabels) {
        return EditConfigHelper.supportMultiEdit(configRegistry, configLabels);
    }

    @Override
    public boolean openAdjacentEditor() {
        return EditConfigHelper.openAdjacentEditor(this.configRegistry, this.labelStack.getLabels());
    }

    @Override
    public boolean activateAtAnyPosition() {
        return true;
    }

    @Override
    public void addEditorControlListeners() {
        Control editorControl = this.getEditorControl();
        if (editorControl != null && !editorControl.isDisposed() && this.editMode == EditModeEnum.INLINE) {
            editorControl.addFocusListener(this.focusListener);
            editorControl.addTraverseListener(this.traverseListener);
        }
    }

    @Override
    public void removeEditorControlListeners() {
        Control editorControl = this.getEditorControl();
        if (editorControl != null && !editorControl.isDisposed()) {
            editorControl.removeFocusListener(this.focusListener);
            editorControl.removeTraverseListener(this.traverseListener);
        }
    }

    public void setDataValidator(IDataValidator validator) {
        this.dataValidator = validator;
    }

    private class InlineFocusListener
    extends FocusAdapter {
        private InlineFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            if (!AbstractCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.NONE, true)) {
                if (e.widget instanceof Control && !e.widget.isDisposed()) {
                    ((Control)e.widget).forceFocus();
                }
            } else {
                AbstractCellEditor.this.parent.forceFocus();
            }
        }
    }

    private class InlineTraverseListener
    implements TraverseListener {
        private InlineTraverseListener() {
        }

        public void keyTraversed(TraverseEvent event) {
            boolean committed = false;
            if (event.keyCode == 9 && event.stateMask == 131072) {
                committed = AbstractCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.LEFT);
            } else if (event.keyCode == 9 && event.stateMask == 0) {
                committed = AbstractCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.RIGHT);
            }
            if (!committed) {
                event.doit = false;
            }
        }
    }
}

