/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.command;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.CellVisualChangeEvent;

public class UpdateDataCommandHandler
extends AbstractLayerCommandHandler<UpdateDataCommand> {
    private static final Log log = LogFactory.getLog(UpdateDataCommandHandler.class);
    private final DataLayer dataLayer;

    public UpdateDataCommandHandler(DataLayer dataLayer) {
        this.dataLayer = dataLayer;
    }

    @Override
    public Class<UpdateDataCommand> getCommandClass() {
        return UpdateDataCommand.class;
    }

    @Override
    protected boolean doCommand(UpdateDataCommand command) {
        try {
            int columnPosition = command.getColumnPosition();
            int rowPosition = command.getRowPosition();
            this.dataLayer.getDataProvider().setDataValue(columnPosition, rowPosition, command.getNewValue());
            this.dataLayer.fireLayerEvent(new CellVisualChangeEvent(this.dataLayer, columnPosition, rowPosition));
            return true;
        }
        catch (UnsupportedOperationException e) {
            log.error((Object)("Failed to update value to: " + command.getNewValue()), (Throwable)e);
            return false;
        }
    }
}

