/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.command;

import java.util.HashSet;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.edit.ActiveCellEditorRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class EditUtils {
    public static ILayerCell getLastSelectedCell(SelectionLayer selectionLayer) {
        PositionCoordinate selectionAnchor = selectionLayer.getSelectionAnchor();
        return selectionLayer.getCellByPosition(selectionAnchor.columnPosition, selectionAnchor.rowPosition);
    }

    public static ICellEditor getLastSelectedCellEditor(SelectionLayer selectionLayer, IConfigRegistry configRegistry) {
        ILayerCell lastSelectedCell = EditUtils.getLastSelectedCell(selectionLayer);
        if (lastSelectedCell != null) {
            List<String> lastSelectedCellLabelsArray = lastSelectedCell.getConfigLabels().getLabels();
            return configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, "EDIT", lastSelectedCellLabelsArray);
        }
        return null;
    }

    public static boolean allCellsEditable(SelectionLayer selectionLayer, IConfigRegistry configRegistry) {
        PositionCoordinate[] selectedCells = selectionLayer.getSelectedCellPositions();
        ILayerCell layerCell = null;
        PositionCoordinate[] positionCoordinateArray = selectedCells;
        int n = selectedCells.length;
        int n2 = 0;
        while (n2 < n) {
            PositionCoordinate cell = positionCoordinateArray[n2];
            layerCell = selectionLayer.getCellByPosition(cell.columnPosition, cell.rowPosition);
            LabelStack labelStack = layerCell.getConfigLabels();
            IEditableRule editableRule = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, "EDIT", labelStack.getLabels());
            if (!editableRule.isEditable(layerCell, configRegistry)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isCellEditable(SelectionLayer selectionLayer, IConfigRegistry configRegistry, PositionCoordinate cellCoords) {
        ILayerCell layerCell = selectionLayer.getCellByPosition(cellCoords.columnPosition, cellCoords.rowPosition);
        LabelStack labelStack = layerCell.getConfigLabels();
        IEditableRule editableRule = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, "EDIT", labelStack.getLabels());
        if (editableRule == null) {
            return false;
        }
        return editableRule.isEditable(layerCell, configRegistry);
    }

    public static boolean isEditorSame(SelectionLayer selectionLayer, IConfigRegistry configRegistry) {
        PositionCoordinate[] selectedCells = selectionLayer.getSelectedCellPositions();
        ICellEditor lastSelectedCellEditor = null;
        PositionCoordinate[] positionCoordinateArray = selectedCells;
        int n = selectedCells.length;
        int n2 = 0;
        while (n2 < n) {
            PositionCoordinate selectedCell = positionCoordinateArray[n2];
            LabelStack labelStack = selectionLayer.getConfigLabelsByPosition(selectedCell.columnPosition, selectedCell.rowPosition);
            ICellEditor cellEditor = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, "EDIT", labelStack.getLabels());
            if (lastSelectedCellEditor == null) {
                lastSelectedCellEditor = cellEditor;
            }
            if (cellEditor != lastSelectedCellEditor) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isConverterSame(SelectionLayer selectionLayer, IConfigRegistry configRegistry) {
        PositionCoordinate[] selectedCells = selectionLayer.getSelectedCellPositions();
        HashSet converterSet = new HashSet();
        PositionCoordinate[] positionCoordinateArray = selectedCells;
        int n = selectedCells.length;
        int n2 = 0;
        while (n2 < n) {
            PositionCoordinate selectedCell = positionCoordinateArray[n2];
            LabelStack labelStack = selectionLayer.getConfigLabelsByPosition(selectedCell.columnPosition, selectedCell.rowPosition);
            IDisplayConverter dataTypeConverter = configRegistry.getConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, "EDIT", labelStack.getLabels());
            if (dataTypeConverter != null) {
                converterSet.add(dataTypeConverter.getClass());
            }
            if (converterSet.size() > 1) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isValueSame(SelectionLayer selectionLayer) {
        PositionCoordinate[] selectedCells;
        Object lastSelectedValue = null;
        PositionCoordinate[] positionCoordinateArray = selectedCells = selectionLayer.getSelectedCellPositions();
        int n = selectedCells.length;
        int n2 = 0;
        while (n2 < n) {
            PositionCoordinate selectedCell = positionCoordinateArray[n2];
            Object cellValue = selectionLayer.getCellByPosition(selectedCell.columnPosition, selectedCell.rowPosition).getDataValue();
            if (lastSelectedValue == null) {
                lastSelectedValue = cellValue;
            }
            if (cellValue != null && !cellValue.equals(lastSelectedValue) || cellValue == null && lastSelectedValue != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean commitAndCloseActiveEditor() {
        ICellEditor activeCellEditor = ActiveCellEditorRegistry.getActiveCellEditor();
        if (activeCellEditor != null) {
            return activeCellEditor.commit(SelectionLayer.MoveDirectionEnum.NONE, true);
        }
        return true;
    }
}

