/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.command;

import java.util.ArrayList;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.edit.EditController;
import org.eclipse.nebula.widgets.nattable.edit.command.EditSelectionCommand;
import org.eclipse.nebula.widgets.nattable.edit.command.EditUtils;
import org.eclipse.nebula.widgets.nattable.edit.event.InlineCellEditEvent;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.swt.widgets.Composite;

public class EditSelectionCommandHandler
extends AbstractLayerCommandHandler<EditSelectionCommand> {
    private SelectionLayer selectionLayer;

    public EditSelectionCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public Class<EditSelectionCommand> getCommandClass() {
        return EditSelectionCommand.class;
    }

    @Override
    public boolean doCommand(EditSelectionCommand command) {
        Composite parent = command.getParent();
        IConfigRegistry configRegistry = command.getConfigRegistry();
        Character initialValue = command.getCharacter();
        if (EditUtils.allCellsEditable(this.selectionLayer, configRegistry) && EditUtils.isEditorSame(this.selectionLayer, configRegistry) && EditUtils.isConverterSame(this.selectionLayer, configRegistry)) {
            PositionCoordinate[] selectedCellPositions = this.selectionLayer.getSelectedCellPositions();
            if (selectedCellPositions.length == 1) {
                PositionCoordinate selectedCell = selectedCellPositions[0];
                ILayerCell cell = this.selectionLayer.getCellByPosition(selectedCell.columnPosition, selectedCell.rowPosition);
                this.selectionLayer.fireLayerEvent(new InlineCellEditEvent(this.selectionLayer, new PositionCoordinate(this.selectionLayer, selectedCell.columnPosition, selectedCell.rowPosition), parent, configRegistry, initialValue != null ? initialValue : cell.getDataValue()));
            } else if (selectedCellPositions.length > 1) {
                ArrayList<ILayerCell> selectedCells = new ArrayList<ILayerCell>();
                PositionCoordinate[] positionCoordinateArray = selectedCellPositions;
                int n = selectedCellPositions.length;
                int n2 = 0;
                while (n2 < n) {
                    PositionCoordinate coord = positionCoordinateArray[n2];
                    selectedCells.add(this.selectionLayer.getCellByPosition(coord.columnPosition, coord.rowPosition));
                    ++n2;
                }
                Object initialEditValue = initialValue;
                if (initialValue == null && EditUtils.isValueSame(this.selectionLayer)) {
                    initialEditValue = this.selectionLayer.getDataValueByPosition(selectedCellPositions[0].columnPosition, selectedCellPositions[0].rowPosition);
                }
                EditController.editCells(selectedCells, parent, initialEditValue, configRegistry);
            }
        }
        return true;
    }
}

