/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.ActiveCellEditorRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.EditTypeEnum;
import org.eclipse.nebula.widgets.nattable.edit.InlineEditHandler;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.gui.CellEditDialogFactory;
import org.eclipse.nebula.widgets.nattable.edit.gui.ICellEditDialog;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EditController {
    private static final Log log = LogFactory.getLog(EditController.class);

    public static void editCell(ILayerCell cell, Composite parent, Object initialCanonicalValue, IConfigRegistry configRegistry) {
        try {
            Rectangle cellBounds = cell.getBounds();
            ILayer layer = cell.getLayer();
            int columnPosition = cell.getColumnPosition();
            int rowPosition = cell.getRowPosition();
            List<String> configLabels = cell.getConfigLabels().getLabels();
            ICellEditor cellEditor = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, "EDIT", configLabels);
            if (cellEditor.openInline(configRegistry, configLabels)) {
                InlineEditHandler editHandler = new InlineEditHandler(layer, columnPosition, rowPosition);
                Rectangle editorBounds = layer.getLayerPainter().adjustCellBounds(columnPosition, rowPosition, new Rectangle(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height));
                cellEditor.activateCell(parent, initialCanonicalValue, EditModeEnum.INLINE, editHandler, cell, configRegistry);
                Control editorControl = cellEditor.getEditorControl();
                if (editorControl != null && !editorControl.isDisposed()) {
                    editorControl.setBounds(editorBounds);
                    cellEditor.addEditorControlListeners();
                    ActiveCellEditorRegistry.registerActiveCellEditor(cellEditor);
                }
            } else {
                ArrayList<ILayerCell> cells = new ArrayList<ILayerCell>();
                cells.add(cell);
                EditController.editCells(cells, parent, initialCanonicalValue, configRegistry);
            }
        }
        catch (Exception e) {
            if (cell == null) {
                log.error((Object)("Cell being edited is no longer available. Initial value: " + initialCanonicalValue), (Throwable)e);
            }
            log.error((Object)("Error while editing cell: Cell: " + cell + "; Initial value: " + initialCanonicalValue), (Throwable)e);
        }
    }

    public static void editCells(List<ILayerCell> cells, Composite parent, Object initialCanonicalValue, IConfigRegistry configRegistry) {
        if (cells != null && !cells.isEmpty()) {
            ICellEditDialog dialog;
            int returnValue;
            ICellEditor cellEditor = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, "EDIT", cells.get(0).getConfigLabels().getLabels());
            if ((cells.size() == 1 || cells.size() > 1 && EditController.supportMultiEdit(cells, cellEditor, configRegistry)) && (returnValue = (dialog = CellEditDialogFactory.createCellEditDialog(parent != null ? parent.getShell() : null, initialCanonicalValue, cells.get(0), cellEditor, configRegistry)).open()) == 0) {
                for (ILayerCell selectedCell : cells) {
                    Object editorValue = dialog.getCommittedValue();
                    if (dialog.getEditType() != EditTypeEnum.SET) {
                        editorValue = dialog.calculateValue(selectedCell.getDataValue(), editorValue);
                    }
                    ILayer layer = selectedCell.getLayer();
                    layer.doCommand(new UpdateDataCommand(layer, selectedCell.getColumnPosition(), selectedCell.getRowPosition(), editorValue));
                }
            }
        }
    }

    private static boolean supportMultiEdit(List<ILayerCell> cells, ICellEditor cellEditor, IConfigRegistry configRegistry) {
        for (ILayerCell cell : cells) {
            if (cellEditor.supportMultiEdit(configRegistry, cell.getConfigLabels().getLabels())) continue;
            return false;
        }
        return true;
    }
}

