/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import java.util.Collection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Functions;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.layer0.Layer0;
import org.simantics.selectionview.ComparableTabContributor;
import org.simantics.selectionview.ModelledTabContributor;
import org.simantics.selectionview.SelectionViewResources;
import org.simantics.selectionview.TabContribution;
import org.simantics.views.swt.SWTViewLoaderProcess;
import org.simantics.views.swt.client.base.SWTRoot;

public class VariableTabContribution
implements TabContribution<Variable> {
    private final Resource configuration;

    public VariableTabContribution(ReadGraph graph, Resource configuration) throws DatabaseException {
        this.configuration = configuration;
    }

    @Override
    public boolean accept(ReadGraph graph, Object input) {
        return input instanceof Variable;
    }

    @Override
    public void contribute(ReadGraph graph, Variable variable, Collection<ComparableTabContributor> result) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SelectionViewResources SEL = SelectionViewResources.getInstance((ReadGraph)graph);
        Resource view = graph.getPossibleObject(this.configuration, SEL.VariableTabContribution_HasView);
        if (view == null) {
            throw new DatabaseException("No view for " + graph.getPossibleURI(this.configuration));
        }
        Integer priority = (Integer)graph.getPossibleRelatedValue(this.configuration, SEL.VariableTabContribution_HasPriority, (Binding)Bindings.INTEGER);
        String label = (String)graph.getPossibleRelatedValue(this.configuration, L0.HasLabel);
        for (Resource r : graph.getObjects(this.configuration, SEL.VariableTabContribution_HasTest)) {
            Boolean pass = (Boolean)Functions.exec((RequestProcessor)graph, (Resource)r, (Object[])new Object[]{graph, variable});
            if (pass.booleanValue()) continue;
            return;
        }
        final String viewURI = graph.getPossibleURI(view);
        result.add(new ComparableTabContributor(new ModelledTabContributor(){

            @Override
            public void createControls(Composite body, IWorkbenchSite site) {
                try {
                    final SWTViewLoaderProcess loader = new SWTViewLoaderProcess(null, site);
                    SWTRoot root = (SWTRoot)loader.load(viewURI, this.runtime);
                    root.createControls(body);
                    body.addListener(12, new Listener(){

                        public void handleEvent(Event event) {
                            if (!loader.isDisposed()) {
                                loader.dispose();
                            }
                        }
                    });
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                    Logger.defaultLogError((Throwable)e);
                }
            }
        }, priority.intValue(), variable, label));
    }
}

