/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.simantics.Logger;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.utils.Functions;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.request.VariableIndexRoot;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.selectionview.ComparableTabContributor;
import org.simantics.selectionview.SelectionInput;
import org.simantics.selectionview.SelectionProcessor;
import org.simantics.selectionview.SelectionViewResources;
import org.simantics.selectionview.TabContribution;
import org.simantics.ui.selection.WorkbenchSelectionUtils;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;

public class StandardSelectionProcessor
implements SelectionProcessor<Object, ReadGraph> {
    private static Resource getIndexRoot(ReadGraph graph, Object selection) throws DatabaseException {
        Resource r;
        Variable variable = WorkbenchSelectionUtils.getPossibleVariable((RequestProcessor)graph, (Object)selection);
        if (variable != null) {
            return (Resource)graph.sync((ReadInterface)new VariableIndexRoot(variable));
        }
        variable = (Variable)ISelectionUtils.filterSingleSelection((Object)selection, Variable.class);
        if (variable != null) {
            return (Resource)graph.sync((ReadInterface)new VariableIndexRoot(variable));
        }
        Resource indexRoot = (Resource)ISelectionUtils.getSinglePossibleKey((Object)selection, (IHintContext.Key)SelectionHints.KEY_MODEL, Resource.class);
        if (indexRoot == null && (r = (Resource)ISelectionUtils.getSinglePossibleKey((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class)) != null) {
            indexRoot = (Resource)graph.sync((ReadInterface)new PossibleIndexRoot(r));
        }
        return indexRoot != null && graph.isInstanceOf(indexRoot, Layer0.getInstance((ReadGraph)graph).IndexRoot) ? indexRoot : null;
    }

    @Override
    public Collection<?> process(Object selection, ReadGraph graph) {
        return StandardSelectionProcessor.processStatic(selection, graph);
    }

    public static Collection<?> processStatic(Object selection, ReadGraph graph) {
        try {
            SelectionViewResources SEL = SelectionViewResources.getInstance((ReadGraph)graph);
            Instances contributionFinder = (Instances)graph.adapt(SEL.TabContribution, Instances.class);
            Instances transformationFinder = (Instances)graph.adapt(SEL.SelectionTransformation, Instances.class);
            ArrayList<TabContribution> contributions = new ArrayList<TabContribution>();
            Resource index = StandardSelectionProcessor.getIndexRoot(graph, selection);
            if (index != null) {
                for (Resource r : contributionFinder.find(graph, index)) {
                    TabContribution contribution = (TabContribution)graph.adapt(r, TabContribution.class);
                    contributions.add(contribution);
                }
                ArrayList transforms = new ArrayList();
                transforms.addAll(transformationFinder.find(graph, index));
                HashSet<Object> inputs = new HashSet<Object>();
                inputs.add(selection);
                boolean changed = true;
                while (changed) {
                    HashSet<Object> newInputs = new HashSet<Object>();
                    for (Resource tr : transforms) {
                        for (Object e : inputs) {
                            try {
                                Object newInput = Functions.exec((RequestProcessor)graph, (Resource)tr, (Object[])new Object[]{graph, e});
                                if (newInput == null) continue;
                                newInputs.add(newInput);
                            }
                            catch (DatabaseException newInput) {
                                // empty catch block
                            }
                        }
                    }
                    changed = inputs.addAll(newInputs);
                }
                HashSet<ComparableTabContributor> result = new HashSet<ComparableTabContributor>();
                for (TabContribution c : contributions) {
                    for (Object e : inputs) {
                        try {
                            if (!c.accept(graph, e)) continue;
                            c.contribute(graph, e, result);
                        }
                        catch (ClassCastException e2) {
                            Logger.defaultLogError((Throwable)e2);
                        }
                        catch (Exception e3) {
                            Logger.defaultLogError((Throwable)e3);
                        }
                    }
                }
                return result;
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return Collections.emptyList();
    }

    private static String inputName(ReadGraph graph, Object o) throws DatabaseException {
        if (o instanceof Resource) {
            return "Resource: " + NameUtils.getSafeLabel((ReadGraph)graph, (Resource)((Resource)o));
        }
        if (o instanceof Variable) {
            return "Variable: " + ((Variable)o).getURI(graph) + " " + NameUtils.getSafeLabel((ReadGraph)graph, (Resource)((Resource)((Variable)o).getPossiblePropertyValue(graph, "Type")));
        }
        if (o instanceof SelectionInput) {
            return "SelectionInput: " + o.toString();
        }
        return "Object(" + o.getClass().getSimpleName() + "): " + o.toString();
    }
}

