/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.selectionview.SelectionViewResources;

public class SelectionViewUtils {
    public static Variable getSpecialCategory(ReadGraph graph, Resource rule, Variable info) throws DatabaseException {
        SelectionViewResources SEL = SelectionViewResources.getInstance((ReadGraph)graph);
        Resource categoryResource = info.getPossibleRepresents(graph);
        if (SEL.CategoryHidden.equals(categoryResource)) {
            Variable property = info.getParent(graph);
            Variable parent = property.getParent(graph);
            if (Variables.Role.PROPERTY.equals(parent.getPossiblePropertyValue(graph, "Role"))) {
                return null;
            }
            Resource predicate = property.getPossiblePredicateResource(graph);
            Variable ruleVariable = Variables.getVariable((ReadGraph)graph, (Resource)rule);
            Function1 getSpecialCategory = (Function1)ruleVariable.getPossiblePropertyValue(graph, SEL.getSpecialCategory);
            if (getSpecialCategory == null) {
                return null;
            }
            SCLContext sclContext = SCLContext.getCurrent();
            try {
                sclContext.put((Object)"graph", (Object)graph);
                Resource cat = (Resource)getSpecialCategory.apply((Object)predicate);
                if (cat != null) {
                    Variable variable = Variables.getVariable((ReadGraph)graph, (Resource)cat);
                    return variable;
                }
            }
            catch (Throwable t) {
                throw new DatabaseException(t);
            }
            finally {
                sclContext.remove((Object)"graph");
            }
        }
        return null;
    }
}

