/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.common.views.IFilterArea;
import org.simantics.browsing.ui.common.views.IFilterAreaProvider;
import org.simantics.browsing.ui.swt.PartNameListener;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.DisposableAsyncListener;
import org.simantics.db.common.procedure.adapter.ListenerSupport;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceNotFoundException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteInterface;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.ontology.ScenegraphResources;
import org.simantics.selectionview.IPropertyTab;
import org.simantics.selectionview.IPropertyTab2;
import org.simantics.selectionview.PropertyTabContributor;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.jface.ActiveSelectionProvider;

public abstract class ModelledTabContributor
implements PropertyTabContributor,
ListenerSupport {
    protected Resource runtime;
    protected boolean disposed = false;
    protected ISelection input = StructuredSelection.EMPTY;
    protected ISelectionProvider selectionProvider = new ActiveSelectionProvider();

    public abstract void createControls(Composite var1, IWorkbenchSite var2);

    public IFilterArea getFilterArea() {
        return null;
    }

    public void requestFocus() {
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public Read<String> getPartNameReadRequest(final ISelection forSelection) {
        return new UniqueRead<String>(){

            private String forResource(ReadGraph graph, Resource resource) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)resource);
                Resource type = graph.getPossibleType(resource, L0.Entity);
                if (type != null) {
                    name = String.valueOf(name) + " : " + NameUtils.getSafeName((ReadGraph)graph, (Resource)type);
                }
                return name;
            }

            public String perform(ReadGraph graph) throws DatabaseException {
                Resource represents;
                Resource resource = (Resource)ISelectionUtils.filterSingleSelection((Object)forSelection, Resource.class);
                if (resource != null) {
                    return this.forResource(graph, resource);
                }
                Variable variable = (Variable)ISelectionUtils.filterSingleSelection((Object)forSelection, Variable.class);
                if (variable != null && (represents = variable.getPossibleRepresents(graph)) != null) {
                    return this.forResource(graph, represents);
                }
                return "Selection";
            }
        };
    }

    public void updatePartName(ISelection forSelection, Callback<String> updateCallback) {
        Read<String> read = this.getPartNameReadRequest(forSelection);
        if (read == null) {
            updateCallback.run((Object)"Selection");
        } else {
            Simantics.getSession().asyncRequest(read, (org.simantics.db.procedure.Listener)new PartNameListener(updateCallback, (ListenerSupport)this));
        }
    }

    public void updatePartName(Callback<String> updateCallback) {
        this.updatePartName(this.input, updateCallback);
    }

    protected void dispose() {
        this.disposed = true;
    }

    public void exception(Throwable t) {
        ErrorLogger.defaultLogError((String)"PropertyTabContributorImpl received unexpected exception.", (Throwable)t);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public Control createControl(Composite parent, IWorkbenchSite site) {
        class TabComposite
        extends Composite {
            public TabComposite(Composite parent, IWorkbenchSite iWorkbenchSite) {
                super(parent, 0);
                GridLayoutFactory.fillDefaults().applyTo(parent);
                GridDataFactory.fillDefaults().span(1, 1).grab(true, true).applyTo((Control)this);
                TabComposite body = this;
                GridLayoutFactory.fillDefaults().spacing(0, 0).equalWidth(false).numColumns(1).applyTo((Composite)body);
                try {
                    ModelledTabContributor.this.createControls(body, iWorkbenchSite);
                }
                catch (Throwable t) {
                    ErrorLogger.defaultLogError((Throwable)t);
                }
            }
        }
        TabComposite tc = new TabComposite(parent, site);
        tc.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                ModelledTabContributor.this.dispose();
            }
        });
        return tc;
    }

    @Override
    public IPropertyTab create(Composite parent, IWorkbenchSite site, ISessionContext context, Object input) {
        Tab tab = new Tab(site, parent);
        tab.createControl((Composite)tab.getControl(), context);
        return tab;
    }

    static class InputListener
    extends DisposableAsyncListener<Pair<Variable, Resource>> {
        final Resource runtime;

        public InputListener(Resource runtime) {
            this.runtime = runtime;
        }

        public void execute(AsyncReadGraph graph, final Pair<Variable, Resource> result) {
            Simantics.getSession().async((WriteInterface)new WriteRequest((VirtualGraph)Simantics.getSession().getService(VirtualGraph.class)){

                public void perform(WriteGraph graph) throws DatabaseException {
                    ScenegraphResources SG = ScenegraphResources.getInstance((ReadGraph)graph);
                    if (result.first != null) {
                        String uri = ((Variable)result.first).getURI((ReadGraph)graph);
                        graph.claimLiteral(InputListener.this.runtime, SG.Runtime_HasVariable, (Object)uri, (Binding)Bindings.STRING);
                    }
                    if (result.second != null) {
                        graph.deny(InputListener.this.runtime, SG.Runtime_HasResource);
                        graph.claim(InputListener.this.runtime, SG.Runtime_HasResource, (Resource)result.second);
                    }
                }
            });
        }

        public void exception(AsyncReadGraph graph, Throwable throwable) {
            Logger.defaultLogError((Throwable)throwable);
        }
    }

    static class InputRead
    extends UniqueRead<Pair<Variable, Resource>> {
        private Object input;

        InputRead(Object input) {
            this.input = input;
        }

        public Pair<Variable, Resource> perform(ReadGraph graph) throws DatabaseException {
            Variable resultVariable = null;
            Resource resultResource = null;
            if (this.input instanceof ISelection) {
                Resource res;
                Variable var = (Variable)ISelectionUtils.filterSingleSelection((Object)((ISelection)this.input), Variable.class);
                if (var != null) {
                    resultVariable = var;
                }
                if ((res = (Resource)ISelectionUtils.filterSingleSelection((Object)((ISelection)this.input), Resource.class)) != null) {
                    resultResource = res;
                }
            } else if (this.input instanceof Resource) {
                resultResource = (Resource)this.input;
            }
            return Pair.make(resultVariable, resultResource);
        }
    }

    class Tab
    extends Composite
    implements IPropertyTab2,
    IFilterAreaProvider {
        final IWorkbenchSite site;
        private InputListener listener;

        public Tab(IWorkbenchSite site, Composite parent) {
            super(parent, 0);
            this.site = site;
            try {
                ModelledTabContributor.this.runtime = (Resource)Simantics.getSession().sync((WriteInterface)new WriteResultRequest<Resource>((VirtualGraph)Simantics.getSession().getService(VirtualGraph.class)){

                    public Resource perform(WriteGraph graph) throws DatabaseException {
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        ScenegraphResources SG = ScenegraphResources.getInstance((ReadGraph)graph);
                        Resource runtime = graph.newResource();
                        graph.claim(runtime, L0.InstanceOf, null, SG.Runtime);
                        return runtime;
                    }
                });
            }
            catch (ServiceNotFoundException e) {
                Logger.defaultLogError((Throwable)e);
            }
            catch (DatabaseException e) {
                Logger.defaultLogError((Throwable)e);
            }
        }

        @Override
        public void createControl(Composite parent, ISessionContext context) {
            Control c = ModelledTabContributor.this.createControl(parent, this.site);
            c.addListener(12, new Listener(){

                public void handleEvent(Event e) {
                    if (Tab.this.listener != null) {
                        Tab.this.listener.dispose();
                        Tab.this.listener = null;
                    }
                }
            });
        }

        @Override
        public Control getControl() {
            return this;
        }

        @Override
        public boolean isDisposed() {
            return super.isDisposed();
        }

        @Override
        public void requestFocus() {
            ModelledTabContributor.this.requestFocus();
        }

        @Override
        public void setInput(ISessionContext context, ISelection selection, boolean force) {
            ModelledTabContributor.this.input = selection;
            if (this.listener != null) {
                this.listener.dispose();
            }
            this.listener = new InputListener(ModelledTabContributor.this.runtime);
            try {
                Simantics.getSession().syncRequest((Read)new InputRead(ModelledTabContributor.this.input), (AsyncProcedure)this.listener);
            }
            catch (DatabaseException e) {
                Logger.defaultLogError((Throwable)e);
            }
        }

        @Override
        public ISelectionProvider getSelectionProvider() {
            return ModelledTabContributor.this.getSelectionProvider();
        }

        public IFilterArea getFilterArea() {
            return ModelledTabContributor.this.getFilterArea();
        }

        @Override
        public void updatePartName(Callback<String> updateCallback) {
            ModelledTabContributor.this.updatePartName(ModelledTabContributor.this.input, updateCallback);
        }
    }
}

