/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import java.io.IOException;
import org.simantics.common.format.Formatter;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.MutableStringBinding;
import org.simantics.databoard.parser.DataValuePrinter;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.databoard.primitives.MutableString;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.adaption.SimpleContextualAdapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.ModelledVariablePropertyDescriptor;
import org.simantics.db.layer0.variable.StandardGraphPropertyVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;

public class DisplayValueVariableAdapter
extends SimpleContextualAdapter<Variable, ModelledVariablePropertyDescriptor> {
    final String key;

    public DisplayValueVariableAdapter() {
        this.key = "http://www.simantics.org/SelectionView-1.2/HasDisplayValue";
    }

    public DisplayValueVariableAdapter(String key) {
        this.key = key;
    }

    public boolean isPrimitive(Datatype dt) {
        return Datatypes.STRING.equals((Object)dt);
    }

    private String possibleExpression(ReadGraph graph, Variable variable) throws DatabaseException {
        String expression;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource object = variable.getPossibleRepresents(graph);
        if (object != null && graph.isInstanceOf(object, MOD.SCLValue) && (expression = (String)graph.getPossibleRelatedValue(object, L0.SCLValue_expression)) != null) {
            return "=" + expression;
        }
        return null;
    }

    public String getDisplayValue(ReadGraph graph, Variable property) throws DatabaseException {
        String expression = this.possibleExpression(graph, property);
        if (expression != null) {
            return expression;
        }
        Object value = property.getValue(graph);
        Resource formatter = (Resource)property.getPossiblePropertyValue(graph, "HasFormatter");
        if (formatter != null) {
            Formatter fmt = (Formatter)graph.adaptContextual(formatter, (Object)property, Variable.class, Formatter.class);
            value = fmt.format(value);
        } else {
            Datatype dt = (Datatype)property.getPossiblePropertyValue(graph, "DATATYPE");
            if (dt != null && !this.isPrimitive(dt)) {
                Binding binding = Bindings.getBinding((Datatype)dt);
                try {
                    value = DataValuePrinter.writeValueSingleLine((Binding)binding, (Object)value);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (BindingException e) {
                    e.printStackTrace();
                }
            }
        }
        return value != null ? value.toString() : "null";
    }

    public Variable adapt(ReadGraph graph, Resource source, ModelledVariablePropertyDescriptor context) throws DatabaseException {
        return new Impl(graph, context.getVariable(), context.getSubject(), (Datatype)Datatypes.STRING);
    }

    class Impl
    extends StandardGraphPropertyVariable {
        private Datatype datatype;

        public Impl(ReadGraph graph, Variable parent, Resource parentResource, Datatype datatype) throws DatabaseException {
            super(parent, parentResource, graph.getResource(DisplayValueVariableAdapter.this.key));
            this.datatype = datatype;
        }

        public <T> T getValue(ReadGraph graph) throws DatabaseException {
            return (T)DisplayValueVariableAdapter.this.getDisplayValue(graph, this.parent);
        }

        public <T> T getValue(ReadGraph graph, Binding binding) throws DatabaseException {
            return (T)DisplayValueVariableAdapter.this.getDisplayValue(graph, this.parent);
        }

        public Datatype getDatatype(ReadGraph graph) throws DatabaseException {
            return this.datatype;
        }

        private String decodeType(ReadGraph graph, Variable variable) throws DatabaseException {
            Datatype dt = Layer0Utils.getDatatype((ReadGraph)graph, (Variable)variable);
            return dt.toSingleLineString();
        }

        private boolean isAsserted(ReadGraph graph, Resource subject, Resource predicate) throws DatabaseException {
            Statement stm = graph.getPossibleStatement(subject, predicate);
            return stm.isAsserted(subject);
        }

        public void setExpression(WriteGraph graph, Variable variable, String text) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            Variable context = variable.getParent((ReadGraph)graph);
            Resource object = context.getRepresents((ReadGraph)graph);
            Resource predicateResource = context.getPredicateResource((ReadGraph)graph);
            Variable parent = context.getParent((ReadGraph)graph);
            Resource parentResource = parent.getRepresents((ReadGraph)graph);
            boolean hasExpression = graph.isInstanceOf(object, MOD.SCLValue);
            String t = this.decodeType((ReadGraph)graph, context);
            if (this.isAsserted((ReadGraph)graph, parentResource, predicateResource)) {
                Resource newValue = graph.newResource();
                graph.claim(newValue, L0.InstanceOf, MOD.SCLValue);
                graph.claimLiteral(newValue, L0.HasValueType, (Object)t, (Binding)Bindings.STRING);
                graph.claimLiteral(newValue, L0.SCLValue_expression, (Object)text.substring(1), (Binding)Bindings.STRING);
                graph.claim(parentResource, predicateResource, newValue);
            } else if (hasExpression) {
                graph.claimLiteral(object, L0.SCLValue_expression, (Object)text.substring(1), (Binding)Bindings.STRING);
            } else {
                Resource newValue = graph.newResource();
                graph.claim(newValue, L0.InstanceOf, MOD.SCLValue);
                graph.claimLiteral(newValue, L0.HasValueType, (Object)t, (Binding)Bindings.STRING);
                graph.claimLiteral(newValue, L0.SCLValue_expression, (Object)text.substring(1), (Binding)Bindings.STRING);
                graph.deny(parentResource, predicateResource);
                graph.claim(parentResource, predicateResource, newValue);
            }
        }

        public void setValue(WriteGraph graph, Object value) throws DatabaseException {
            try {
                Binding binding = Bindings.getBinding(value.getClass());
                this.setValue(graph, value, binding);
            }
            catch (BindingConstructionException e) {
                throw new DatabaseException((Throwable)e);
            }
        }

        public void setValue(WriteGraph graph, Object _value, Binding _binding) throws DatabaseException {
            try {
                if (!(_value instanceof String)) {
                    throw new DatabaseException("setValue for HasDisplayValue only accepts String (got " + _value.getClass().getSimpleName() + ")");
                }
                String text = (String)_value;
                if (text.startsWith("=")) {
                    this.setExpression(graph, (Variable)this, text);
                    return;
                }
                String parsedLabel = (String)_value;
                Object value = parsedLabel;
                Datatype type = (Datatype)this.parent.getPossiblePropertyValue((ReadGraph)graph, "DATATYPE");
                if (type != null) {
                    Binding binding = Bindings.getBinding((Datatype)type);
                    if (binding instanceof StringBinding) {
                        value = binding instanceof MutableStringBinding ? new MutableString(parsedLabel) : parsedLabel;
                    } else {
                        if (binding instanceof NumberBinding) {
                            parsedLabel = parsedLabel.replace(",", ".");
                        }
                        value = binding.parseValue(parsedLabel, new DataValueRepository());
                    }
                    this.parent.setValue(graph, value, binding);
                } else {
                    this.parent.setValue(graph, value);
                }
                CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                graph.addMetadata((Metadata)cm.add("Set value " + ObjectUtils.toString((Object)value)));
            }
            catch (DataTypeSyntaxError e) {
                throw new DatabaseException((Throwable)e);
            }
            catch (BindingException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
    }
}

