/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import java.util.Collection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Functions;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.layer0.Layer0;
import org.simantics.selectionview.ComparableTabContributor;
import org.simantics.selectionview.SelectionInput;
import org.simantics.selectionview.SelectionViewResources;
import org.simantics.selectionview.TabContribution;
import org.simantics.ui.selection.WorkbenchSelectionUtils;

public abstract class AbstractVariableTabContribution
implements TabContribution<Object> {
    private final String uri;
    protected final Resource configuration;

    public AbstractVariableTabContribution(ReadGraph graph, Resource configuration) throws DatabaseException {
        this.configuration = configuration;
        this.uri = graph.getURI(configuration);
    }

    public abstract void getContributors(ReadGraph var1, Variable var2, Integer var3, String var4, Collection<ComparableTabContributor> var5) throws DatabaseException;

    @Override
    public boolean accept(ReadGraph graph, Object input) throws DatabaseException {
        return true;
    }

    public boolean accept(ReadGraph graph, Variable variable, Object selection) throws DatabaseException {
        if (selection instanceof SelectionInput) {
            SelectionViewResources SEL = SelectionViewResources.getInstance((ReadGraph)graph);
            for (Resource r : graph.getObjects(this.configuration, SEL.AbstractVariableTabContribution_HasTest)) {
                Boolean pass = (Boolean)Functions.exec((RequestProcessor)graph, (Resource)r, (Object[])new Object[]{graph, (SelectionInput)selection});
                if (pass.booleanValue()) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private final Variable getPossibleVariable(ReadGraph graph, Object selection) throws DatabaseException {
        SelectionInput si;
        if (selection instanceof SelectionInput && (si = (SelectionInput)selection).getElements().size() == 1) {
            return WorkbenchSelectionUtils.getPossibleVariable((RequestProcessor)graph, (Object)si.getElements().iterator().next());
        }
        return null;
    }

    @Override
    public final void contribute(ReadGraph graph, Object selection, Collection<ComparableTabContributor> result) throws DatabaseException {
        Variable variable = this.getPossibleVariable(graph, selection);
        if (variable == null) {
            return;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SelectionViewResources SEL = SelectionViewResources.getInstance((ReadGraph)graph);
        Integer priority = (Integer)graph.getPossibleRelatedValue(this.configuration, SEL.AbstractVariableTabContribution_HasPriority, (Binding)Bindings.INTEGER);
        String label = (String)graph.getPossibleRelatedValue(this.configuration, L0.HasLabel);
        if (!this.accept(graph, variable, selection)) {
            return;
        }
        this.getContributors(graph, variable, priority, label, result);
    }

    public String toString() {
        return "AbstractVariableTabContribution[" + this.uri + "]";
    }
}

