/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.reflection.internal.registry;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.simantics.scl.reflection.MinimalTypeBindingScheme;
import org.simantics.scl.reflection.ReflectionUtils;
import org.simantics.scl.reflection.TypeBindingScheme;
import org.simantics.scl.reflection.TypeNotFoundException;
import org.simantics.scl.reflection.TypedValue;
import org.simantics.scl.reflection.ValueNotFoundException;
import org.simantics.scl.reflection.annotations.SCLType;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.scl.reflection.functions.ClassMethodFunction;
import org.simantics.scl.reflection.functions.ConstructorFunction;
import org.simantics.scl.reflection.functions.FieldAccessorFunction;
import org.simantics.scl.reflection.functions.InstanceMethodFunction;
import org.simantics.scl.reflection.internal.Activator;
import org.simantics.scl.reflection.internal.registry.Entry;
import org.simantics.scl.reflection.internal.registry.ExternalClass;
import org.simantics.scl.reflection.internal.registry.ExternalMethod;
import org.simantics.scl.reflection.internal.registry.ImportSeq;
import org.simantics.scl.reflection.internal.typeRegistry.TypeRegistry;
import org.simantics.scl.runtime.function.FunctionImplN;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.SCLTypeParseException;
import org.simantics.scl.types.util.ITypeEnvironment;

public class Namespace {
    String namespace;
    ImportSeq importSeq;
    ArrayList<Entry> classes = new ArrayList();
    ArrayList<ExternalClass> externalClasses = new ArrayList();
    ArrayList<ExternalMethod> externalMethods = new ArrayList();
    volatile THashMap<String, Class<?>> types;
    volatile THashMap<String, TypedValue> values;
    ITypeEnvironment typeEnvironment = new ITypeEnvironment(){

        public Type resolve(String namespace, String name) {
            if (namespace == null) {
                namespace = TypeRegistry.isBuiltin(name) ? "Builtin" : (Namespace.this.types.contains((Object)name) ? Namespace.this.namespace : "");
            } else {
                ImportSeq cur = Namespace.this.importSeq;
                while (cur != null) {
                    if (namespace.equals(cur.localName)) {
                        namespace = cur.path;
                        break;
                    }
                    cur = cur.parent;
                }
            }
            return Types.con((String)namespace, (String)name);
        }
    };

    public Namespace(String namespace, ImportSeq importSeq) {
        this.namespace = namespace;
        this.importSeq = importSeq;
    }

    public void addClass(Entry e) {
        this.classes.add(e);
    }

    public void addExternalMethod(ExternalMethod e) {
        this.externalMethods.add(e);
    }

    public void addExternalClass(ExternalClass e) {
        this.externalClasses.add(e);
    }

    public Class<?> getClass(String name) throws TypeNotFoundException {
        Class type;
        if (this.types == null) {
            try {
                this.initializeTypes();
            }
            catch (Exception e) {
                throw new TypeNotFoundException(e);
            }
        }
        if ((type = (Class)this.types.get((Object)name)) == null) {
            throw new TypeNotFoundException("Didn't find type " + name + ".");
        }
        return type;
    }

    public TypedValue getValue(String name) throws ValueNotFoundException {
        TypedValue value;
        if (this.values == null) {
            try {
                this.initializeValues();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ValueNotFoundException(e);
            }
        }
        if ((value = (TypedValue)this.values.get((Object)name)) == null) {
            throw new ValueNotFoundException("Didn't find value " + name + ".");
        }
        return value;
    }

    private Type parseType(String typeText) throws SCLTypeParseException {
        return Types.closure((Type)Types.parseType((ITypeEnvironment)this.typeEnvironment, (String)typeText));
    }

    private synchronized void initializeTypes() {
        if (this.types == null) {
            Class<?> clazz;
            this.types = new THashMap();
            for (Entry entry : this.classes) {
                clazz = entry.loadClass();
                if (clazz == null) {
                    Activator.logError("Didn't find class " + entry.name + ".");
                    continue;
                }
                SCLType sclType = clazz.getAnnotation(SCLType.class);
                if (sclType == null) continue;
                String name = sclType.name();
                if (name.isEmpty()) {
                    name = clazz.getSimpleName();
                }
                this.types.put((Object)name, clazz);
            }
            for (ExternalClass externalClass : this.externalClasses) {
                clazz = externalClass.loadClass();
                if (clazz == null) {
                    Activator.logError("Didn't find class " + externalClass.className + ".");
                    continue;
                }
                String name = externalClass.alternativeName;
                if (name == null) {
                    name = clazz.getSimpleName();
                }
                this.types.put((Object)name, clazz);
            }
        }
    }

    private void handleMethod(TypeBindingScheme scheme, Class<?> clazz, Method method) {
        SCLValue sclValue = method.getAnnotation(SCLValue.class);
        if (sclValue != null) {
            Type type;
            String name = sclValue.name();
            if (name.isEmpty()) {
                name = method.getName();
            }
            try {
                type = this.parseType(sclValue.type());
            }
            catch (SCLTypeParseException e) {
                Activator.logError("Method " + method.getName() + " in class " + clazz.getCanonicalName() + " has invalid type declaration.", (Exception)((Object)e));
                return;
            }
            try {
                if (ReflectionUtils.isCompatible(scheme, type, method)) {
                    FunctionImplN value = Modifier.isStatic(method.getModifiers()) ? new ClassMethodFunction(method) : new InstanceMethodFunction(method);
                    this.values.put((Object)name, (Object)new TypedValue(type, value));
                } else {
                    Activator.logError("Method " + method.getName() + " in class " + clazz.getCanonicalName() + " has incompantible SCL type in the SCLValue annotation.");
                    ReflectionUtils.isCompatible(scheme, type, method);
                }
            }
            catch (TypeNotFoundException e) {
                Activator.logError("Couldn't find all types in the type declaration of method " + method.getName() + " in class " + clazz.getCanonicalName() + ".");
            }
        }
    }

    private void handleConstructor(TypeBindingScheme scheme, Class<?> clazz, Constructor<?> constr) {
        SCLValue sclValue = constr.getAnnotation(SCLValue.class);
        if (sclValue != null) {
            Type type;
            String name = sclValue.name();
            if (name.isEmpty()) {
                name = constr.getDeclaringClass().getSimpleName();
            }
            try {
                type = this.parseType(sclValue.type());
            }
            catch (SCLTypeParseException e) {
                Activator.logError("Constructor in " + clazz.getCanonicalName() + " has invalid type declaration.", (Exception)((Object)e));
                return;
            }
            try {
                if (ReflectionUtils.isCompatible(scheme, type, constr)) {
                    ConstructorFunction value = new ConstructorFunction(constr);
                    this.values.put((Object)name, (Object)new TypedValue(type, (Object)value));
                } else {
                    Activator.logError("Constructor of " + clazz.getCanonicalName() + " has incompantible SCL type in the SCLValue annotation.");
                }
            }
            catch (TypeNotFoundException e) {
                Activator.logError("Couldn't find all types in the type declaration of constructor in " + clazz.getCanonicalName() + ".");
            }
        }
    }

    private void handleField(TypeBindingScheme scheme, Class<?> clazz, Field field) {
        SCLValue sclValue = field.getAnnotation(SCLValue.class);
        if (sclValue != null) {
            Type type;
            String name = sclValue.name();
            if (name.isEmpty()) {
                name = field.getName();
            }
            try {
                type = this.parseType(sclValue.type());
            }
            catch (SCLTypeParseException e) {
                Activator.logError("Field " + field.getName() + " in class " + clazz.getCanonicalName() + " has invalid type declaration.", (Exception)((Object)e));
                return;
            }
            try {
                if (ReflectionUtils.isCompatible(scheme, type, field)) {
                    Object value;
                    if (Modifier.isStatic(field.getModifiers())) {
                        try {
                            value = field.get(null);
                        }
                        catch (IllegalArgumentException e) {
                            Activator.logError("Cannot read field " + field.getName() + " in class " + clazz.getCanonicalName() + ".", e);
                            return;
                        }
                        catch (IllegalAccessException e) {
                            Activator.logError("Cannot read field " + field.getName() + " in class " + clazz.getCanonicalName() + ".", e);
                            return;
                        }
                    } else {
                        value = new FieldAccessorFunction(field);
                    }
                    this.values.put((Object)name, (Object)new TypedValue(type, value));
                } else {
                    Activator.logError("Field " + field.getName() + " in class " + clazz.getCanonicalName() + " has incompantible SCL type in the SCLValue annotation.");
                }
            }
            catch (TypeNotFoundException e) {
                Activator.logError("Couldn't find all types in the type declaration of field " + field.getName() + " in class " + clazz.getCanonicalName() + ".");
            }
        }
    }

    private synchronized void initializeValues() {
        if (this.values == null) {
            Method method;
            Class<?> clazz;
            this.initializeTypes();
            MinimalTypeBindingScheme scheme = MinimalTypeBindingScheme.INSTANCE;
            this.values = new THashMap();
            for (Entry entry : this.classes) {
                clazz = entry.loadClass();
                if (clazz == null) {
                    Activator.logError("Didn't find class " + entry.name + ".");
                    continue;
                }
                AccessibleObject[] accessibleObjectArray = clazz.getMethods();
                int n = accessibleObjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    method = accessibleObjectArray[n2];
                    this.handleMethod(scheme, clazz, method);
                    ++n2;
                }
                accessibleObjectArray = clazz.getConstructors();
                n = accessibleObjectArray.length;
                n2 = 0;
                while (n2 < n) {
                    Executable constr = accessibleObjectArray[n2];
                    this.handleConstructor(scheme, clazz, (Constructor<?>)constr);
                    ++n2;
                }
                accessibleObjectArray = clazz.getFields();
                n = accessibleObjectArray.length;
                n2 = 0;
                while (n2 < n) {
                    AccessibleObject field = accessibleObjectArray[n2];
                    this.handleField(scheme, clazz, (Field)field);
                    ++n2;
                }
            }
            for (ExternalMethod externalMethod : this.externalMethods) {
                clazz = externalMethod.loadClass();
                if (clazz == null) {
                    Activator.logError("Didn't find class " + externalMethod.className + ".");
                    continue;
                }
                method = externalMethod.getMethod(clazz);
                if (method == null) {
                    Activator.logError("Didn't find method " + externalMethod.methodName + " in class " + externalMethod.className + ".");
                    continue;
                }
                this.handleMethod(scheme, clazz, method);
            }
        }
    }

    public void print() {
        for (Entry entry : this.classes) {
            System.out.println("    " + entry.name + " (" + entry.bundle + ")");
        }
        try {
            this.initializeTypes();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.types.forEachEntry(new TObjectObjectProcedure<String, Class<?>>(){

            public boolean execute(String name, Class<?> clazz) {
                System.out.println("    type " + name + " = " + clazz.getCanonicalName());
                return true;
            }
        });
        try {
            this.initializeValues();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.values.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<String, TypedValue>(){

            public boolean execute(String name, TypedValue value) {
                System.out.println("    " + name + " :: " + value.getType());
                return true;
            }
        });
    }
}

