/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.reflection.internal.registry;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.osgi.framework.Bundle;
import org.simantics.scl.reflection.OntologyVersions;
import org.simantics.scl.reflection.TypeNotFoundException;
import org.simantics.scl.reflection.TypedValue;
import org.simantics.scl.reflection.ValueNotFoundException;
import org.simantics.scl.reflection.internal.Activator;
import org.simantics.scl.reflection.internal.registry.Entry;
import org.simantics.scl.reflection.internal.registry.ExternalClass;
import org.simantics.scl.reflection.internal.registry.ExternalMethod;
import org.simantics.scl.reflection.internal.registry.ImportSeq;
import org.simantics.scl.reflection.internal.registry.Namespace;
import org.simantics.scl.types.TCon;

public class BindingRegistry {
    private static boolean DEBUG_INIT = false;
    private static THashMap<String, Namespace> namespaces = new THashMap();

    static {
        BindingRegistry.initialize();
        if (DEBUG_INIT) {
            namespaces.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<String, Namespace>(){

                public boolean execute(String name, Namespace namespace) {
                    System.out.println(name);
                    namespace.print();
                    return true;
                }
            });
        }
    }

    public static TypedValue getValue(String path, String name) throws ValueNotFoundException {
        Namespace namespace = (Namespace)namespaces.get((Object)path);
        if (namespace == null) {
            throw new ValueNotFoundException("Didn't find namespace " + path + ".");
        }
        return namespace.getValue(name);
    }

    public static Class<?> getClass(TCon type) throws TypeNotFoundException {
        Namespace namespace = (Namespace)namespaces.get((Object)type.module);
        if (namespace == null) {
            throw new TypeNotFoundException("Didn't find namespace " + type.module + ".");
        }
        return namespace.getClass(type.name);
    }

    public static void initialize() {
        IConfigurationElement[] elements;
        namespaces.clear();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.simantics.scl.reflection.binding");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            Bundle bundle = BindingRegistry.getBundle(element);
            BindingRegistry.findBindings(bundle, null, element, null);
            ++n2;
        }
    }

    private static Bundle getBundle(IConfigurationElement element) {
        IContributor contributor = element.getContributor();
        if (contributor instanceof RegistryContributor) {
            long id = Long.parseLong(((RegistryContributor)contributor).getActualId());
            return Activator.getInstance().getContext().getBundle(id);
        }
        return Platform.getBundle((String)contributor.getName());
    }

    private static Namespace getOrCreateNamespace(String path, ImportSeq importSeq) {
        Namespace namespace = (Namespace)namespaces.get((Object)path);
        if (namespace == null) {
            namespace = new Namespace(path, importSeq);
            namespaces.put((Object)path, (Object)namespace);
        }
        return namespace;
    }

    private static void findBindings(Bundle bundle, String path, IConfigurationElement element, ImportSeq importSeq) {
        String elementName = element.getName();
        if (elementName.equals("namespace")) {
            IConfigurationElement childElement;
            if ((path = path == null ? OntologyVersions.getInstance().currentVersion(element.getAttribute("path")) : OntologyVersions.getInstance().currentVersion(String.valueOf(path) + "/" + element.getAttribute("path"))).endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            IConfigurationElement[] iConfigurationElementArray = element.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                childElement = iConfigurationElementArray[n2];
                if (childElement.getName().equals("import")) {
                    String path_ = OntologyVersions.getInstance().currentVersion(childElement.getAttribute("path"));
                    String localName = childElement.getAttribute("localName");
                    importSeq = new ImportSeq(importSeq, localName, path_);
                }
                ++n2;
            }
            iConfigurationElementArray = element.getChildren();
            n = iConfigurationElementArray.length;
            n2 = 0;
            while (n2 < n) {
                childElement = iConfigurationElementArray[n2];
                BindingRegistry.findBindings(bundle, path, childElement, importSeq);
                ++n2;
            }
        } else if (elementName.equals("class")) {
            String className = element.getAttribute("className");
            BindingRegistry.getOrCreateNamespace(path, importSeq).addClass(new Entry(bundle, className));
        } else if (elementName.equals("externalClass")) {
            String className = element.getAttribute("className");
            String alternativeName = element.getAttribute("alternativeName");
            BindingRegistry.getOrCreateNamespace(path, importSeq).addExternalClass(new ExternalClass(bundle, className, alternativeName));
        } else if (elementName.equals("externalMethod")) {
            String className = element.getAttribute("className");
            String methodName = element.getAttribute("methodName");
            String alternativeName = element.getAttribute("alternativeName");
            BindingRegistry.getOrCreateNamespace(path, importSeq).addExternalMethod(new ExternalMethod(bundle, className, methodName, alternativeName));
        }
    }
}

