/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.views.swt.client.impl;

import java.awt.Rectangle;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.lobobrowser.html.renderer.RBlock;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.utils.datastructures.map.Tuple;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.SWTThread;
import org.simantics.views.swt.client.base.SingleSWTViewNode;
import org.simantics.views.swt.client.impl.SWTScrolledComposite;
import org.simantics.wiki.ui.SimanticsDialect;
import org.simantics.wiki.ui.browser.BrowserComponent;
import org.simantics.wiki.ui.browser.PrintableHtmlPanel;
import org.simantics.wiki.ui.editor.NavigationHandler;
import org.simantics.wiki.ui.language.MediaWikiLanguage;

public class SWTWikiBrowser
extends SingleSWTViewNode<BrowserComponent> {
    private static final long serialVersionUID = 5826022972081217837L;
    public String document;
    public Variable variable;
    public Function1<String, Boolean> navigate;
    public Variable edited;
    private Tuple lastAppliedParametrization;

    @Override
    public void reset() {
        super.reset();
        this.lastAppliedParametrization = null;
    }

    @Override
    public void createControls(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)c);
        GridLayoutFactory.fillDefaults().extendedMargins(10, 10, 10, 10).applyTo(c);
        c.setBackground((Color)this.getResourceManager().get((DeviceResourceDescriptor)ColorDescriptor.createFrom((RGB)new RGB(245, 245, 245))));
        Composite c2 = new Composite(c, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)c2);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 2, 0, 2).applyTo(c2);
        c2.setBackground(Display.getCurrent().getSystemColor(15));
        Composite c3 = new Composite(c2, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)c3);
        GridLayoutFactory.fillDefaults().extendedMargins(1, 1, 1, 1).applyTo(c3);
        c3.setBackground(Display.getCurrent().getSystemColor(2));
        this.control = new BrowserComponent(c3, this.style, new NavigationHandler(){

            public void navigate(URL url, String target) {
                if (SWTWikiBrowser.this.navigate != null) {
                    SWTWikiBrowser.this.navigate.apply((Object)url.toString().substring("http://variable".length()));
                }
            }
        });
        ((BrowserComponent)this.control).syncPopulate();
        ((BrowserComponent)this.control).getPanel().setDefaultOverflowY(0);
        ((BrowserComponent)this.control).getPanel().setDefaultOverflowX(3);
        Logger.getLogger("org.lobobrowser").setLevel(Level.OFF);
        Logger.getLogger("com.steadystate").setLevel(Level.OFF);
        this.setProperties();
    }

    public void synchronizeVariable(Variable variable) {
    }

    public void synchronizeEdited(Variable edited) {
        this.propertyCallback.apply((Object)"edited", (Object)edited);
    }

    public void synchronizeDocument(final String document) {
        if (document != null) {
            final Variable variable = this.variable;
            if (variable == null) {
                return;
            }
            Tuple checkParam = new Tuple(new Object[]{document, variable});
            if (checkParam.equals((Object)this.lastAppliedParametrization)) {
                return;
            }
            this.lastAppliedParametrization = checkParam;
            try {
                String markup = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

                    public String perform(ReadGraph graph) throws DatabaseException {
                        return SimanticsDialect.INSTANCE.apply(graph, variable, document);
                    }
                });
                MarkupParser markupParser = new MarkupParser();
                MediaWikiLanguage language = new MediaWikiLanguage();
                markupParser.setMarkupLanguage((MarkupLanguage)language);
                String htmlContent = markupParser.parseToHtml(markup);
                if (htmlContent == null) {
                    return;
                }
                final BrowserComponent control = (BrowserComponent)this.control;
                if (control == null) {
                    return;
                }
                control.setText(htmlContent);
                final org.eclipse.swt.graphics.Rectangle controlBounds = control.getBounds();
                control.setBounds(0, 0, controlBounds.width, 10000);
                AWTThread.getThreadAccess().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        PrintableHtmlPanel panel = control.getPanel();
                        if (panel == null) {
                            return;
                        }
                        RBlock block = (RBlock)panel.getBlockRenderable();
                        if (block == null) {
                            return;
                        }
                        block.layout(controlBounds.width, controlBounds.height, false, true, 0, 0, false);
                    }
                });
                while (control.readAsyncCounter() > 0) {
                    Thread.sleep(5L);
                }
                AWTThread.getThreadAccess().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PrintableHtmlPanel panel = control.getPanel();
                        if (panel == null) {
                            return;
                        }
                        RBlock block = (RBlock)panel.getBlockRenderable();
                        if (block == null) {
                            return;
                        }
                        block.layout(controlBounds.width, controlBounds.height, false, true, 0, 0, false);
                        final Rectangle bounds = ((RBlock)control.getPanel().getBlockRenderable()).getBounds();
                        SWTThread.getThreadAccess().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (control == null || control.isDisposed()) {
                                    return;
                                }
                                int heightHint = Math.max(400, bounds.height + 25);
                                control.setBounds(0, 0, controlBounds.width, heightHint);
                                GridData data = (GridData)control.getLayoutData();
                                data.heightHint = heightHint;
                                data.grabExcessHorizontalSpace = true;
                                data.grabExcessVerticalSpace = false;
                                control.setLayoutData((Object)data);
                                control.layout();
                                control.getParent().layout();
                                SWTScrolledComposite.propagate((Control)control);
                            }
                        });
                    }
                });
            }
            catch (DatabaseException e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
            catch (InterruptedException e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
        }
    }
}

