/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.views.swt.client.base;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.widgets.Control;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.reflection.BindingRequest;
import org.simantics.databoard.type.Datatype;
import org.simantics.datatypes.literal.Font;
import org.simantics.datatypes.literal.RGB;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.LoaderNode;
import org.simantics.scenegraph.loader.ScenegraphLoaderUtils;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.Function2;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.ui.colors.Colors;
import org.simantics.ui.fonts.Fonts;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SWTThread;
import org.simantics.views.ViewUtils;
import org.simantics.views.swt.client.base.SWTParentNode;
import org.simantics.views.swt.client.base.SWTViewUtils;

public abstract class SingleSWTViewNode<T extends Control>
extends SWTParentNode
implements LoaderNode {
    private static final long serialVersionUID = -5810308021930769003L;
    private Map<String, Object> genericProperties = new HashMap<String, Object>();
    public Function2<String, Object, Boolean> propertyCallback;
    public ViewUtils.GridDataBean layoutData;
    public int style;
    public String text;
    public RGB.Integer background;
    public RGB.Integer foreground;
    public Font font;
    protected transient ColorDescriptor backgroundDesc;
    protected transient ColorDescriptor foregroundDesc;
    protected transient FontDescriptor fontDesc;
    protected T control;

    @Override
    public Control getControl() {
        return this.control;
    }

    @Override
    public void reset() {
        this.control = null;
    }

    protected final boolean isDisposed() {
        if (this.getControl() == null) {
            return false;
        }
        return this.getControl().isDisposed();
    }

    protected final void dispatch(final Runnable runnable) {
        if (this.isNodeDisposed()) {
            return;
        }
        IThreadWorkQueue thread = SWTThread.getThreadAccess();
        if (thread.currentThreadAccess()) {
            runnable.run();
        } else {
            thread.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (SingleSWTViewNode.this.isDisposed()) {
                        return;
                    }
                    if (SingleSWTViewNode.this.control == null) {
                        return;
                    }
                    if (SingleSWTViewNode.this.control.isDisposed()) {
                        return;
                    }
                    runnable.run();
                }
            });
        }
    }

    private Field getPropertyField(String propertyName) {
        assert (!this.isNodeDisposed());
        return ScenegraphLoaderUtils.getPropertyField((INode)this, (String)propertyName);
    }

    private Class<?> getPropertyType(Field field) {
        return field.getType();
    }

    private Binding getPropertyBinding(Field field) {
        try {
            Binding b = Bindings.getBinding((BindingRequest)BindingRequest.create((Field)field));
            if (b instanceof ArrayBinding && ((ArrayBinding)b).type().componentType() == null) {
            }
            return b;
        }
        catch (BindingConstructionException e) {}
        finally {
            return null;
        }
    }

    private Binding getGenericPropertyBinding(Binding binding) {
        if (binding == null) {
            return null;
        }
        return Bindings.getBinding((Datatype)binding.type());
    }

    public Function1<Object, Boolean> getPropertyFunction(final String propertyName) {
        if (this.isNodeDisposed()) {
            return null;
        }
        final Field field = this.getPropertyField(propertyName);
        if (field != null) {
            return new FunctionImpl1<Object, Boolean>(propertyName){
                final Method method;
                final Class<?> type;
                final Binding binding;
                final Binding genericBinding;
                {
                    this.method = ScenegraphLoaderUtils.getSynchronizeMethod((INode)SingleSWTViewNode.this, (String)string);
                    this.type = SingleSWTViewNode.this.getPropertyType(field2);
                    this.binding = SingleSWTViewNode.this.getPropertyBinding(field2);
                    this.genericBinding = SingleSWTViewNode.this.getGenericPropertyBinding(this.binding);
                }

                private Object setField(Object value) {
                    try {
                        if (this.type.isPrimitive() || value == null || this.type.isInstance(value) || this.type.isArray()) {
                            field.set(SingleSWTViewNode.this, value);
                            return value;
                        }
                        Object instance = this.binding.createDefaultUnchecked();
                        this.binding.readFrom(this.genericBinding, value, instance);
                        field.set(SingleSWTViewNode.this, instance);
                        return instance;
                    }
                    catch (IllegalArgumentException e1) {
                        e1.printStackTrace();
                    }
                    catch (IllegalAccessException e1) {
                        e1.printStackTrace();
                    }
                    catch (BindingException e) {
                        e.printStackTrace();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    return null;
                }

                public Boolean apply(Object value) {
                    if (SingleSWTViewNode.this.isNodeDisposed()) {
                        return true;
                    }
                    final Object translated = this.setField(value);
                    if (this.method != null) {
                        SingleSWTViewNode.this.dispatch(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    method.invoke((Object)SingleSWTViewNode.this, translated);
                                }
                                catch (IllegalArgumentException e) {
                                    e.printStackTrace();
                                }
                                catch (IllegalAccessException e) {
                                    e.printStackTrace();
                                }
                                catch (InvocationTargetException e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                    }
                    return SingleSWTViewNode.this.isDisposed();
                }
            };
        }
        return new FunctionImpl1<Object, Boolean>(){

            public Boolean apply(Object p0) {
                if (!$assertionsDisabled && SingleSWTViewNode.this.isNodeDisposed()) {
                    throw new AssertionError();
                }
                SingleSWTViewNode.this.genericProperties.put(propertyName, p0);
                return SingleSWTViewNode.this.isDisposed();
            }
        };
    }

    public void setPropertyCallback(Function2<String, Object, Boolean> callback) {
        this.propertyCallback = callback;
    }

    public <T2> T2 getProperty(String propertyName) {
        Method m = ScenegraphLoaderUtils.getReadMethod((INode)this, (String)propertyName);
        if (m != null) {
            try {
                return (T2)m.invoke((Object)this, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Failed to get property '" + propertyName + "' for " + this.getClass().getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to get property '" + propertyName + "' for " + this.getClass().getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Failed to get property '" + propertyName + "' for " + this.getClass().getName(), e);
            }
        }
        return (T2)this.genericProperties.get(propertyName);
    }

    protected void setProperties() {
        Method[] methodArray = this.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().startsWith("synchronize")) {
                String upperFieldName = m.getName().substring("synchronize".length());
                String fieldName = String.valueOf(upperFieldName.substring(0, 1).toLowerCase()) + upperFieldName.substring(1);
                Field f = ScenegraphLoaderUtils.getPropertyField((INode)this, (String)fieldName);
                try {
                    m.invoke((Object)this, f.get(this));
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Failed to set property '" + fieldName + "' for " + this.getClass().getName(), e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Failed to set property '" + fieldName + "' for " + this.getClass().getName(), e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Failed to set property '" + fieldName + "' for " + this.getClass().getName(), e);
                }
            }
            ++n2;
        }
    }

    public void synchronizeText(String text) {
    }

    public final void synchronizeFont(Font font) {
        if (font == null && this.fontDesc == null) {
            return;
        }
        ResourceManager rm = this.getResourceManager();
        FontDescriptor oldDesc = this.fontDesc;
        if (font != null) {
            this.fontDesc = Fonts.swt((Font)font);
            this.control.setFont(this.getResourceManager().createFont(this.fontDesc));
        }
        if (oldDesc != null) {
            rm.destroy((DeviceResourceDescriptor)oldDesc);
        }
    }

    public final void synchronizeForeground(RGB.Integer foreground) {
        if (foreground == null && this.foregroundDesc == null) {
            return;
        }
        ResourceManager rm = this.getResourceManager();
        ColorDescriptor oldDesc = this.foregroundDesc;
        if (foreground != null) {
            this.foregroundDesc = Colors.swt((RGB.Integer)foreground);
            this.control.setForeground(this.getResourceManager().createColor(this.foregroundDesc));
        }
        if (oldDesc != null) {
            rm.destroy((DeviceResourceDescriptor)oldDesc);
        }
    }

    public final void synchronizeBackground(RGB.Integer background) {
        if (background == null && this.backgroundDesc == null) {
            return;
        }
        ResourceManager rm = this.getResourceManager();
        ColorDescriptor oldDesc = this.backgroundDesc;
        if (background != null) {
            this.backgroundDesc = Colors.swt((RGB.Integer)background);
            this.control.setBackground(this.getResourceManager().createColor(this.backgroundDesc));
        }
        if (oldDesc != null) {
            rm.destroy((DeviceResourceDescriptor)oldDesc);
        }
    }

    public final void synchronizeStyle(int style) {
    }

    public final void synchronizeLayoutData(ViewUtils.GridDataBean layoutData) {
        if (layoutData != null) {
            this.control.setLayoutData((Object)SWTViewUtils.toGridData(layoutData));
        }
    }
}

