/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet;

public class Range {
    public int startRow;
    public int endRow;
    public int startColumn;
    public int endColumn;

    public Range(int startRow, int endRow, int startColumn, int endColumn) {
        this.startRow = startRow;
        this.endRow = endRow;
        this.startColumn = startColumn;
        this.endColumn = endColumn;
    }

    public static Range combine(Range from, Range to) {
        return new Range(from.startRow, to.endRow, from.startColumn, to.endColumn);
    }

    public int size() {
        return (this.endRow - this.startRow + 1) * (this.endColumn - this.startColumn + 1);
    }

    public int width() {
        return this.endColumn - this.startColumn + 1;
    }

    public int height() {
        return this.endRow - this.startRow + 1;
    }

    public String toString() {
        return "Range[(" + this.startRow + "," + this.startColumn + ")-(" + this.endRow + "," + this.endColumn + ")]";
    }
}

