/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection.splitting;

import gnu.trove.set.hash.THashSet;
import java.awt.geom.Point2D;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteNode;
import org.simantics.diagram.connection.RouteTerminal;

public class SplittedRouteGraph {
    public final RouteLine splitLine;
    public final THashSet<RouteNode> interfaceNodes1;
    public final THashSet<RouteLine> lines1;
    public final THashSet<RouteTerminal> terminals1;
    public final THashSet<RouteNode> interfaceNodes2;
    public final THashSet<RouteLine> lines2;
    public final THashSet<RouteTerminal> terminals2;

    public SplittedRouteGraph(RouteLine splitLine, THashSet<RouteNode> interfaceNodes1, THashSet<RouteLine> lines1, THashSet<RouteTerminal> terminals1, THashSet<RouteNode> interfaceNodes2, THashSet<RouteLine> lines2, THashSet<RouteTerminal> terminals2) {
        this.splitLine = splitLine;
        this.interfaceNodes1 = interfaceNodes1;
        this.lines1 = lines1;
        this.terminals1 = terminals1;
        this.interfaceNodes2 = interfaceNodes2;
        this.lines2 = lines2;
        this.terminals2 = terminals2;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("splitLine = " + this.splitLine.getData() + "\n");
        b.append("interfaceNodes1 =");
        for (RouteNode node : this.interfaceNodes1) {
            b.append(" " + node.getData() + "(" + node.getClass().getSimpleName() + ")");
        }
        b.append("\n");
        b.append("lines1 =");
        for (RouteNode node : this.lines1) {
            b.append(" " + ((RouteLine)node).getData());
        }
        b.append("\n");
        b.append("terminals1 =");
        for (RouteNode node : this.terminals1) {
            b.append(" " + ((RouteTerminal)node).getData());
        }
        b.append("\n");
        b.append("interfaceNodes2 =");
        for (RouteNode node : this.interfaceNodes2) {
            b.append(" " + node.getData() + "(" + node.getClass().getSimpleName() + ")");
        }
        b.append("\n");
        b.append("lines2 =");
        for (RouteNode node : this.lines2) {
            b.append(" " + ((RouteLine)node).getData());
        }
        b.append("\n");
        b.append("terminals2 =");
        for (RouteNode node : this.terminals2) {
            b.append(" " + ((RouteTerminal)node).getData());
        }
        b.append("\n");
        return b.toString();
    }

    public static RouteLine findNearestLine(RouteGraph rg, Point2D splitCanvasPos) {
        double hi = 1000.0;
        double lo = 1.0;
        RouteLine nearestLine = null;
        double LIMIT = 0.5;
        while (true) {
            double tolerance = (hi + lo) * 0.5;
            RouteLine line = rg.pickLine(splitCanvasPos.getX(), splitCanvasPos.getY(), tolerance);
            double delta = (hi - lo) * 0.5;
            if (delta < 0.5) {
                return nearestLine;
            }
            if (line == null) {
                lo = tolerance;
                continue;
            }
            nearestLine = line;
            hi = tolerance;
        }
    }

    public static Point2D snapToLine(Point2D point, RouteLine line) {
        if (line.isHorizontal()) {
            point.setLocation(point.getX(), line.getPosition());
        } else {
            point.setLocation(line.getPosition(), point.getY());
        }
        return point;
    }

    public static Point2D snappedToLine(Point2D point, RouteLine line) {
        Point2D result = (Point2D)point.clone();
        return SplittedRouteGraph.snapToLine(result, line);
    }
}

