/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection.rendering.arrows;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.simantics.diagram.connection.rendering.arrows.ILineEndStyle;

public class ArrowLineEndStyle
implements ILineEndStyle,
Serializable {
    private static final long serialVersionUID = -346653685430483245L;
    public static final double DEFAULT_LENGTH = 8.0;
    public static final double DEFAULT_WIDTH = 4.0;
    public static final double DEFAULT_SPACE = 0.0;
    protected ArrowType type;
    protected double lineEndLength;
    protected double length;
    protected double width;
    protected double space;
    protected Color color;
    protected transient Path2D path;

    public ArrowLineEndStyle() {
        this(8.0, 4.0, 0.0, null);
    }

    public ArrowLineEndStyle(double length, double width, double space) {
        this(length, width, space, null);
    }

    public ArrowLineEndStyle(double length, double width, double space, Color color) {
        this.type = ArrowType.Fill;
        this.length = length;
        this.width = width;
        this.space = space;
        this.color = color;
        this.path = ArrowLineEndStyle.arrow(length, width, space);
    }

    public ArrowLineEndStyle(String desc) {
        this.type = ArrowType.None;
        this.lineEndLength = 0.0;
        double l = 8.0;
        double w = 4.0;
        double s = 0.0;
        StringTokenizer tokenizer = new StringTokenizer(desc);
        if (tokenizer.hasMoreTokens()) {
            String type = tokenizer.nextToken();
            this.type = ArrowLineEndStyle.parseType(type);
            if (tokenizer.hasMoreTokens()) {
                String ls = tokenizer.nextToken();
                l = ArrowLineEndStyle.parseSize(ls, this.length);
                if (tokenizer.hasMoreTokens()) {
                    String ws = tokenizer.nextToken();
                    w = ArrowLineEndStyle.parseSize(ws, this.width);
                    if (tokenizer.hasMoreTokens()) {
                        String ss = tokenizer.nextToken();
                        s = ArrowLineEndStyle.parseSize(ss, this.space);
                    }
                }
            }
            if (this.type != ArrowType.None) {
                this.path = ArrowLineEndStyle.arrow(l, w, s);
                this.lineEndLength = l + s;
            }
        }
        this.width = w;
        this.length = l;
        this.space = s;
    }

    @Override
    public void render(Graphics2D g, double x, double y, int dir) {
        if (this.type == ArrowType.None || this.path == null) {
            return;
        }
        AffineTransform old = g.getTransform();
        g.translate(x, y);
        g.rotate((double)dir * Math.PI * 0.5);
        if (this.color != null) {
            g.setColor(this.color);
        }
        switch (this.type) {
            case Fill: {
                g.fill(this.path);
                break;
            }
            case Stroke: {
                g.draw(this.path);
            }
        }
        g.setTransform(old);
    }

    @Override
    public double getLineEndLength(int direction) {
        return this.lineEndLength;
    }

    private static Path2D arrow(double length, double width, double space) {
        Path2D.Double path = new Path2D.Double();
        path.moveTo(-space, 0.0);
        path.lineTo(-length - space, -width);
        path.lineTo(-length - space, width);
        path.closePath();
        return path;
    }

    private static double parseSize(String size, double defaultValue) {
        try {
            return Double.parseDouble(size);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static ArrowType parseType(String type) {
        String lower = type.toLowerCase();
        if ("none".equals(lower)) {
            return ArrowType.None;
        }
        if ("stroke".equals(lower)) {
            return ArrowType.Stroke;
        }
        if ("fill".equals(lower)) {
            return ArrowType.Fill;
        }
        throw new IllegalArgumentException("unrecognized arrow type: " + type);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "@" + System.identityHashCode(this) + "[" + (Object)((Object)this.type) + ", w=" + this.width + ", l=" + this.length + ", s=" + this.space + ", lel=" + this.lineEndLength + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.length);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.lineEndLength);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.space);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        temp = Double.doubleToLongBits(this.width);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrowLineEndStyle other = (ArrowLineEndStyle)obj;
        if (Double.doubleToLongBits(this.length) != Double.doubleToLongBits(other.length)) {
            return false;
        }
        if (Double.doubleToLongBits(this.lineEndLength) != Double.doubleToLongBits(other.lineEndLength)) {
            return false;
        }
        if (Double.doubleToLongBits(this.space) != Double.doubleToLongBits(other.space)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return Double.doubleToLongBits(this.width) == Double.doubleToLongBits(other.width);
    }

    public static enum ArrowType {
        None,
        Stroke,
        Fill;

    }
}

