/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection.rendering;

import gnu.trove.set.hash.THashSet;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.io.Serializable;
import java.util.List;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RoutePoint;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.rendering.ConnectionStyle;
import org.simantics.diagram.connection.rendering.IRouteGraphRenderer;
import org.simantics.diagram.connection.rendering.arrows.ILineEndStyle;

public class StyledRouteGraphRenderer
implements IRouteGraphRenderer,
Serializable {
    private static final long serialVersionUID = 1564960933064029020L;
    protected final ConnectionStyle style;
    protected transient Path2D path;
    protected transient THashSet<RoutePoint> branchPoints;

    public StyledRouteGraphRenderer(ConnectionStyle style) {
        if (style == null) {
            throw new NullPointerException("null style");
        }
        this.style = style;
    }

    public ConnectionStyle getStyle() {
        return this.style;
    }

    @Override
    public void render(Graphics2D g, RouteGraph rg) {
        if (this.path == null) {
            this.path = new Path2D.Double();
        }
        this.path.reset();
        rg.getPath2D(this.path);
        this.style.drawPath(g, this.path, false);
        if (this.branchPoints == null) {
            this.branchPoints = new THashSet();
        }
        this.branchPoints.clear();
        for (RouteLine line : rg.getLines()) {
            this.renderLine(g, line, false);
            StyledRouteGraphRenderer.collectBranchPoints(line, this.branchPoints);
        }
        for (RouteLine line : rg.getTransientLines()) {
            this.renderLine(g, line, true);
            StyledRouteGraphRenderer.collectBranchPoints(line, this.branchPoints);
        }
        for (RoutePoint point : this.branchPoints) {
            this.style.drawBranchPoint(g, point.getX(), point.getY());
        }
    }

    private static void collectBranchPoints(RouteLine line, THashSet<RoutePoint> branchPoints) {
        List<RoutePoint> points = line.getPoints();
        int i = 1;
        while (i < points.size() - 1) {
            RoutePoint point = points.get(i);
            branchPoints.add((Object)point);
            ++i;
        }
    }

    private void renderLine(Graphics2D g, RouteLine line, boolean isTransient) {
        RoutePoint p1 = line.getBegin();
        RoutePoint p2 = line.getEnd();
        double x1 = p1.getX();
        double y1 = p1.getY();
        double x2 = p2.getX();
        double y2 = p2.getY();
        boolean isHorizontal = line.isHorizontal();
        if (isHorizontal) {
            ILineEndStyle style;
            RouteTerminal terminal;
            if (p1 instanceof RouteTerminal) {
                terminal = (RouteTerminal)p1;
                style = terminal.getStyle();
                style.render(g, x1, y1, 2);
                x1 += style.getLineEndLength(0);
            }
            if (p2 instanceof RouteTerminal) {
                terminal = (RouteTerminal)p2;
                style = terminal.getStyle();
                style.render(g, x2, y2, 0);
                x2 -= style.getLineEndLength(2);
            }
        } else {
            ILineEndStyle style;
            RouteTerminal terminal;
            if (p1 instanceof RouteTerminal) {
                terminal = (RouteTerminal)p1;
                style = terminal.getStyle();
                style.render(g, x1, y1, 3);
                y1 += style.getLineEndLength(1);
            }
            if (p2 instanceof RouteTerminal) {
                terminal = (RouteTerminal)p2;
                style = terminal.getStyle();
                style.render(g, x2, y2, 1);
                y2 -= style.getLineEndLength(3);
            }
        }
    }

    public int hashCode() {
        return this.style.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StyledRouteGraphRenderer other = (StyledRouteGraphRenderer)obj;
        return this.style.equals(other.style);
    }
}

