/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.osgi.internal;

import gnu.trove.set.hash.TLongHashSet;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.osgi.framework.Bundle;
import org.simantics.scl.osgi.internal.Activator;
import org.simantics.scl.osgi.internal.PackageDesc;

public class SCLPackageRegistry {
    private static SCLPackageRegistry INSTANCE = new SCLPackageRegistry();
    private ArrayList<PackageDesc> packages = new ArrayList();
    private ArrayList<Bundle> sclBundles = new ArrayList();

    private SCLPackageRegistry() {
        this.initialize();
    }

    private void initialize() {
        IConfigurationElement[] elements;
        TLongHashSet bundleIds = new TLongHashSet();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.simantics.scl.runtime.package");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            URL entry;
            String directory;
            IConfigurationElement element = iConfigurationElementArray[n2];
            Bundle bundle = SCLPackageRegistry.getBundle(element);
            String uri = element.getAttribute("URI");
            if (uri.endsWith("/")) {
                uri = uri.substring(0, uri.length() - 1);
            }
            if ((directory = element.getAttribute("directory")).startsWith("/")) {
                directory = directory.substring(1);
            }
            if (directory.endsWith("/")) {
                directory = directory.substring(0, directory.length() - 1);
            }
            if ((entry = bundle.getEntry(directory)) != null) {
                this.packages.add(new PackageDesc(bundle, uri, entry));
                if (bundleIds.add(bundle.getBundleId())) {
                    this.sclBundles.add(bundle);
                }
            } else {
                System.err.println("Couldn't resolve directory " + directory + " in bundle " + bundle.getSymbolicName());
            }
            ++n2;
        }
    }

    private static Bundle getBundle(IConfigurationElement element) {
        IContributor contributor = element.getContributor();
        if (contributor instanceof RegistryContributor) {
            long id = Long.parseLong(((RegistryContributor)contributor).getActualId());
            return Activator.getContext().getBundle(id);
        }
        return Platform.getBundle((String)contributor.getName());
    }

    public static SCLPackageRegistry getInstance() {
        return INSTANCE;
    }

    public ArrayList<PackageDesc> getPackages() {
        return this.packages;
    }

    public Bundle[] getSclBundles() {
        return this.sclBundles.toArray(new Bundle[this.sclBundles.size()]);
    }
}

