/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.osgi.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.simantics.scl.compiler.top.SCLSourceLoader;
import org.simantics.scl.compiler.top.Source;
import org.simantics.scl.osgi.internal.BundleSource;
import org.simantics.scl.osgi.internal.PackageDesc;
import org.simantics.scl.osgi.internal.SCLPackageRegistry;

public enum ExtensionSCLSourceLoader implements SCLSourceLoader
{
    INSTANCE;


    public Source locateSource(String name) {
        for (PackageDesc packageDesc : SCLPackageRegistry.getInstance().getPackages()) {
            URL sourceUrl;
            int uriLength = packageDesc.uri.length();
            if (name.length() < uriLength + 2 || !name.startsWith(packageDesc.uri) || name.charAt(uriLength) != '/') continue;
            String nameTail = name.substring(uriLength + 1);
            try {
                sourceUrl = new URL(packageDesc.directory, String.valueOf(nameTail) + ".scl");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                continue;
            }
            try {
                sourceUrl.openStream().close();
            }
            catch (FileNotFoundException e) {
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            return new BundleSource(packageDesc.bundle, name, sourceUrl);
        }
        return null;
    }
}

