/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.osgi.internal;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.cojen.classfile.TypeDesc;
import org.osgi.framework.Bundle;
import org.simantics.scl.compiler.codegen.types.AbstractRuntimeJavaReferenceValidator;
import org.simantics.scl.compiler.codegen.types.JavaReferenceValidator;
import org.simantics.scl.compiler.top.SourceWithReferenceValidator;

public class BundleSource
implements SourceWithReferenceValidator {
    Bundle bundle;
    String moduleName;
    URL url;

    public BundleSource(Bundle bundle, String moduleName, URL url) {
        this.bundle = bundle;
        this.moduleName = moduleName;
        this.url = url;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public Reader getSourceReader() throws IOException {
        return new InputStreamReader(this.url.openStream());
    }

    public JavaReferenceValidator getJavaReferenceValidator() {
        return new BundleReferenceValidator();
    }

    class BundleReferenceValidator
    extends AbstractRuntimeJavaReferenceValidator {
        BundleReferenceValidator() {
        }

        public Class<?> findClass(TypeDesc name) {
            try {
                if (name.isPrimitive()) {
                    return name.toClass();
                }
                return BundleSource.this.bundle.loadClass(name.getFullName());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    }
}

