/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.osgi.internal;

import java.net.URL;
import java.util.Enumeration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.simantics.scl.compiler.top.SCLSourceLoader;
import org.simantics.scl.compiler.top.Source;

public class BundleSCLRegistry
implements SCLSourceLoader {
    BundleContext context;

    public BundleSCLRegistry(BundleContext context) {
        this.context = context;
        this.start();
    }

    private static String bundleEventTypeToString(int eventType) {
        switch (eventType) {
            case 1: {
                return "INSTALLED";
            }
            case 512: {
                return "LAZY_ACTIVATION";
            }
            case 32: {
                return "RESOLVED";
            }
            case 2: {
                return "STARTED";
            }
            case 128: {
                return "STARTING";
            }
            case 4: {
                return "STOPPED";
            }
            case 256: {
                return "STOPPING";
            }
            case 16: {
                return "UNINSTALLED";
            }
            case 64: {
                return "UNRESOLVED";
            }
            case 8: {
                return "UPDATED";
            }
        }
        return "Invalid event type.";
    }

    private void lookAt(Bundle bundle) {
        Enumeration e = bundle.findEntries("scl", "*.scl", true);
        if (e != null) {
            while (e.hasMoreElements()) {
                URL el = (URL)e.nextElement();
                System.out.println(el.getPath());
            }
        }
    }

    private synchronized void start() {
        this.context.addBundleListener(new BundleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void bundleChanged(BundleEvent event) {
                if (event.getType() == 1) {
                    BundleSCLRegistry bundleSCLRegistry = BundleSCLRegistry.this;
                    synchronized (bundleSCLRegistry) {
                        BundleSCLRegistry.this.lookAt(event.getBundle());
                    }
                }
            }
        });
        Bundle[] bundleArray = this.context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            this.lookAt(bundle);
            ++n2;
        }
    }

    public Source locateSource(String name) {
        return null;
    }
}

