/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.osgi;

import java.io.IOException;
import java.io.Reader;
import org.simantics.scl.osgi.CommandResponse;
import org.simantics.scl.osgi.SCLCommandSession;

public class TestScriptExecutor {
    SCLCommandSession session;
    Reader reader;
    private int executedLines = 0;
    String nextLine;

    public TestScriptExecutor(Reader reader, SCLCommandSession session) {
        this.reader = reader;
        this.session = session;
    }

    void pushBackLine(String line) {
        if (this.nextLine != null) {
            throw new IllegalStateException();
        }
        this.nextLine = line;
    }

    String readLine() throws IOException {
        if (this.nextLine != null) {
            String result = this.nextLine;
            this.nextLine = null;
            return result;
        }
        StringBuilder b = new StringBuilder();
        while (true) {
            int c;
            if ((c = this.reader.read()) <= 0) {
                if (b.length() != 0) break;
                return null;
            }
            if (c == 10) break;
            b.append((char)c);
        }
        return b.toString();
    }

    CommandResponsePair readCommandResponsePair() throws IOException {
        String line;
        StringBuilder command = new StringBuilder();
        StringBuilder response = new StringBuilder();
        int firstIndentation = -1;
        int commentOpen = 0;
        while (true) {
            block17: {
                block15: {
                    block16: {
                        if ((line = this.readLine()) == null) {
                            if (firstIndentation >= 0) break;
                            return null;
                        }
                        if (line.charAt(0) != '>') {
                            response.append(line);
                            break;
                        }
                        if (!line.contains("/*")) break block15;
                        ++commentOpen;
                        if (!line.contains("*/")) break block16;
                        --commentOpen;
                        line = this.readLine();
                        break block17;
                    }
                    if (!line.contains("*/")) break block17;
                }
                if (line.contains("*/") && --commentOpen == 0) {
                    line = this.readLine();
                }
            }
            if (commentOpen != 0 || line == null) continue;
            int indentation = 1;
            while (indentation < line.length() && line.charAt(indentation) == ' ') {
                ++indentation;
            }
            if (firstIndentation < 0) {
                firstIndentation = indentation;
            } else {
                if (indentation <= firstIndentation) {
                    this.pushBackLine(line);
                    return new CommandResponsePair(command.toString(), "");
                }
                command.append('\n');
            }
            command.append(line.substring(firstIndentation));
        }
        while ((line = this.readLine()) != null) {
            if (!line.isEmpty() && line.charAt(0) == '>') {
                this.pushBackLine(line);
                break;
            }
            response.append('\n');
            response.append(line);
        }
        if (command.length() == 0) {
            if (response.length() == 0) {
                return this.readCommandResponsePair();
            }
            throw new IOException("Empty command but nonempty response.");
        }
        return new CommandResponsePair(command.toString(), response.toString());
    }

    public ExecutionError execute() throws IOException {
        CommandResponsePair pair;
        CommandResponse response;
        do {
            if ((pair = this.readCommandResponsePair()) == null) {
                return null;
            }
            response = this.session.executeInJob(pair.command);
            ++this.executedLines;
        } while (response.message.trim().equals(pair.response.trim()));
        return new ExecutionError(pair.command, pair.response, response.message);
    }

    public int getExecutedLines() {
        return this.executedLines;
    }

    static class CommandResponsePair {
        String command;
        String response;

        public CommandResponsePair(String command, String response) {
            this.command = command;
            this.response = response;
        }
    }

    public static class ExecutionError {
        public final String command;
        public final String expectedResponse;
        public final String actualResponse;

        public ExecutionError(String command, String expectedResponse, String actualResponse) {
            this.command = command;
            this.expectedResponse = expectedResponse;
            this.actualResponse = actualResponse;
        }
    }
}

