/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.osgi;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.simantics.scl.compiler.elaboration.java.Builtins;
import org.simantics.scl.compiler.elaboration.java.JavaModule;
import org.simantics.scl.compiler.elaboration.modules.CompositeModule;
import org.simantics.scl.compiler.elaboration.modules.Module;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.top.BytecodeContainer;
import org.simantics.scl.compiler.top.MapClassLoader;
import org.simantics.scl.compiler.top.ModuleLoader;
import org.simantics.scl.compiler.top.SCLEnvironment;
import org.simantics.scl.compiler.top.SCLSourceLoader;
import org.simantics.scl.compiler.top.SCLValueCache;
import org.simantics.scl.compiler.top.SpecialModuleLoader;
import org.simantics.scl.compiler.top.StandardModuleLoader;
import org.simantics.scl.compiler.top.ValueNotFound;
import org.simantics.scl.osgi.internal.OsgiSCLSourceLoader;
import org.simantics.scl.osgi.internal.PackageDesc;
import org.simantics.scl.osgi.internal.SCLOsgiClassLoader;
import org.simantics.scl.osgi.internal.SCLPackageRegistry;
import org.simantics.scl.prelude.PreludeCache;

public enum SCLOsgi implements SCLEnvironment
{
    INSTANCE;

    private static StandardModuleLoader MODULE_LOADER;
    private static MapClassLoader CLASS_LOADER;
    private static SCLValueCache VALUE_CACHE;

    private SCLOsgi() {
        SCLOsgi.init();
    }

    public ModuleLoader getModuleLoader() {
        return MODULE_LOADER;
    }

    public MapClassLoader getClassLoader() {
        return CLASS_LOADER;
    }

    public CompositeModule createEnvironmentModule() {
        CompositeModule module = new CompositeModule(this.getModuleLoader());
        module.add("", (Module)Builtins.INSTANCE);
        module.add("", "StandardLibrary");
        return module;
    }

    public SCLValue getValueRef(String name) throws ValueNotFound {
        return VALUE_CACHE.getValueRef(name);
    }

    public Object getValue(String name) throws ValueNotFound {
        return VALUE_CACHE.getValue(name);
    }

    public SCLValueCache getValueCache() {
        return VALUE_CACHE;
    }

    private static void init() {
        CLASS_LOADER = new SCLOsgiClassLoader(PreludeCache.getPreludeClassLoader(), SCLPackageRegistry.getInstance().getSclBundles());
        MODULE_LOADER = new StandardModuleLoader((SCLSourceLoader)OsgiSCLSourceLoader.INSTANCE, (BytecodeContainer)CLASS_LOADER);
        final BundleContext context = FrameworkUtil.getBundle(SCLOsgi.class).getBundleContext();
        ServiceTracker specialModuleLoaderTracker = new ServiceTracker(context, SpecialModuleLoader.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<SpecialModuleLoader, SpecialModuleLoader>(){

            public SpecialModuleLoader addingService(ServiceReference<SpecialModuleLoader> reference) {
                SpecialModuleLoader loader = (SpecialModuleLoader)context.getService(reference);
                MODULE_LOADER.addSpecialModuleLoader(loader);
                return loader;
            }

            public void modifiedService(ServiceReference<SpecialModuleLoader> reference, SpecialModuleLoader service) {
            }

            public void removedService(ServiceReference<SpecialModuleLoader> reference, SpecialModuleLoader service) {
                MODULE_LOADER.removeSpecialModuleLoader(service);
            }
        });
        specialModuleLoaderTracker.open();
        VALUE_CACHE = new SCLValueCache((ModuleLoader)MODULE_LOADER, (ClassLoader)CLASS_LOADER);
        MODULE_LOADER.addModule((Module)Builtins.INSTANCE);
        MODULE_LOADER.addModule((Module)JavaModule.INSTANCE);
        MODULE_LOADER.addModule(PreludeCache.getPrelude());
    }

    public static void reset() {
        SCLOsgi.init();
    }

    public ArrayList<String> getAllModules() {
        ArrayList<String> result = new ArrayList<String>();
        Module[] moduleArray = PreludeCache.getPrelude();
        int n = moduleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Module m = moduleArray[n2];
            result.add(m.getModuleName());
            ++n2;
        }
        for (PackageDesc packageDesc : SCLPackageRegistry.getInstance().getPackages()) {
            Enumeration en = packageDesc.bundle.findEntries(packageDesc.directory.getPath(), "*.scl", false);
            while (en.hasMoreElements()) {
                URL e = (URL)en.nextElement();
                String file = e.getPath();
                int slashPos = file.lastIndexOf(47);
                if (slashPos >= 0) {
                    file = file.substring(slashPos + 1);
                }
                result.add(String.valueOf(packageDesc.uri) + "/" + file.substring(0, file.length() - 4));
            }
        }
        return result;
    }
}

