/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.osgi;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectProcedure;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.scl.compiler.codegen.utils.NameMangling;
import org.simantics.scl.compiler.codegen.values.Constant;
import org.simantics.scl.compiler.codegen.values.StringConstant;
import org.simantics.scl.compiler.common.errors.SCLError;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EGetContext;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.modules.CompositeModule;
import org.simantics.scl.compiler.elaboration.modules.ContextModule;
import org.simantics.scl.compiler.elaboration.modules.Module;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.parsing.declarations.DImportAst;
import org.simantics.scl.compiler.top.CommandLanguageDescription;
import org.simantics.scl.compiler.top.CompiledCommand;
import org.simantics.scl.compiler.top.ContextInjection;
import org.simantics.scl.compiler.top.ExpressionInterfaceDescription;
import org.simantics.scl.compiler.top.SCLCompilationErrorHandler;
import org.simantics.scl.compiler.top.SCLErrorFormatter;
import org.simantics.scl.compiler.top.SCLExpressionCompilationException;
import org.simantics.scl.compiler.top.SCLExpressionCompiler;
import org.simantics.scl.compiler.top.SCLValueCache;
import org.simantics.scl.compiler.top.Source;
import org.simantics.scl.compiler.top.StringSource;
import org.simantics.scl.compiler.top.ValueNotFound;
import org.simantics.scl.osgi.CommandExecutionException;
import org.simantics.scl.osgi.CommandResponse;
import org.simantics.scl.osgi.CommandScriptExecutor;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.osgi.TestScriptExecutor;
import org.simantics.scl.runtime.ContextualComputation;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.scl.runtime.procedure.Printer;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.kinds.Kind;
import org.simantics.scl.types.kinds.Kinds;

public class SCLCommandSession {
    private boolean PRINT_COMMANDS = false;
    private static final String CONTEXT_MODULE = "Expressions/Context";
    private static final TCon CONTEXT = Types.con((String)"Expressions/Context", (String)"Context");
    private static SCLValue GET;
    private static SCLValue PUT;
    private static final TVar A;
    private static final ExpressionInterfaceDescription<ContextualComputation> CONTEXTUAL_COMPUTATION;
    private static final ContextInjection CONTEXT_INJECTION;
    private static final CommandLanguageDescription LANGUAGE_DESCRIPTION;
    THashMap<String, Object> context = new THashMap();
    THashMap<String, Type> contextTypes = new THashMap();
    ArrayList<Import> imports = new ArrayList();
    Printer printer;
    private String previousCommand;
    private Object previousResult;
    private Job job;
    private static final String THIS_CLASS_NAME;
    private SCLCompilationErrorHandler compilationErrorHandler = new SCLCompilationErrorHandler(){

        public void handle(String moduleName, Source source, SCLError[] errors) {
            SCLCommandSession.this.printer.print("While compiling " + moduleName);
            SCLCommandSession.this.printer.print(SCLErrorFormatter.toString((Source)source, (SCLError[])errors));
        }

        public void handle(String moduleName, Exception exception) {
            SCLCommandSession.this.printer.print("While compiling " + moduleName);
            SCLCommandSession.this.printer.print(exception.toString());
        }
    };

    static {
        try {
            GET = SCLOsgi.INSTANCE.getValueRef("Expressions/Context/contextGet");
            PUT = SCLOsgi.INSTANCE.getValueRef("Expressions/Context/contextPut");
        }
        catch (ValueNotFound e) {
            e.printStackTrace();
        }
        A = Types.var((Kind)Kinds.STAR);
        CONTEXTUAL_COMPUTATION = new ExpressionInterfaceDescription(ContextualComputation.class, new TVar[]{A}, true, (Type)A, "execute", new Type[]{CONTEXT});
        CONTEXT_INJECTION = new ContextInjection(){

            public Expression createContextInjection(String variableName) {
                return new EApply(9223372034707292160L, (Expression)new EConstant(PUT), new Expression[]{new EGetContext(0, (Type)CONTEXT), new ELiteral((Constant)new StringConstant(variableName)), new EVar(variableName)});
            }
        };
        LANGUAGE_DESCRIPTION = new CommandLanguageDescription(CONTEXT_INJECTION, true, true);
        THIS_CLASS_NAME = SCLCommandSession.class.getName();
    }

    public SCLCommandSession(Printer printer) {
        this.printer = printer;
        this.initializeContext();
    }

    private void initializeContext() {
        this.context.clear();
        this.contextTypes.clear();
        this.context.put((Object)"runFromFile", (Object)new FunctionImpl1<String, Tuple0>(){

            public Tuple0 apply(String fileName) {
                SCLCommandSession.this.runFromFile(fileName);
                return Tuple0.INSTANCE;
            }
        });
        this.context.put((Object)"runTestFile", (Object)new FunctionImpl1<String, Tuple0>(){

            public Tuple0 apply(String fileName) {
                SCLCommandSession.this.runTestFile(fileName);
                return Tuple0.INSTANCE;
            }
        });
        this.context.put((Object)"runTest", (Object)new FunctionImpl1<String, Tuple0>(){

            public Tuple0 apply(String testName) {
                SCLCommandSession.this.runTest(testName);
                return Tuple0.INSTANCE;
            }
        });
        this.context.put((Object)"reset", (Object)new FunctionImpl1<Object, Tuple0>(){

            public Tuple0 apply(Object unit) {
                SCLCommandSession.this.reset();
                return Tuple0.INSTANCE;
            }
        });
        this.contextTypes.put((Object)"runFromFile", (Object)Types.functionE((Type)Types.STRING, (Type)Types.PROC, (Type)Types.tuple((Type[])new Type[0])));
        this.contextTypes.put((Object)"runTestFile", (Object)Types.functionE((Type)Types.STRING, (Type)Types.PROC, (Type)Types.tuple((Type[])new Type[0])));
        this.contextTypes.put((Object)"runTest", (Object)Types.functionE((Type)Types.STRING, (Type)Types.PROC, (Type)Types.tuple((Type[])new Type[0])));
        this.contextTypes.put((Object)"reset", (Object)Types.functionE((Type)Types.UNIT, (Type)Types.PROC, (Type)Types.tuple((Type[])new Type[0])));
    }

    public CompositeModule createEnvironmentModule() {
        CompositeModule environmentModule = SCLOsgi.INSTANCE.createEnvironmentModule();
        environmentModule.add(null, CONTEXT_MODULE);
        environmentModule.add("", (Module)new ContextModule("LocalContext"){

            protected Expression createValueExpression(String name) {
                if (!SCLCommandSession.this.context.containsKey((Object)name)) {
                    return null;
                }
                Type type = (Type)SCLCommandSession.this.contextTypes.get((Object)name);
                return new EApply(9223372034707292160L, (Expression)new EConstant(GET, new Type[]{type}), new Expression[]{new EGetContext(0, (Type)CONTEXT), new ELiteral((Constant)new StringConstant(name))});
            }

            protected void findValuesForPrefix(Collection<SCLValue> values, String prefix) {
                String lowerPrefix = prefix.toLowerCase();
                for (String key : SCLCommandSession.this.contextTypes.keySet()) {
                    String lowerKey = key.toLowerCase();
                    if (!lowerKey.startsWith(lowerPrefix)) continue;
                    values.add(this.getValue(key));
                }
            }
        });
        for (Import import_ : this.imports) {
            environmentModule.add(import_.namespace, import_.module);
        }
        return environmentModule;
    }

    private Object compile(String command) throws SCLExpressionCompilationException {
        DImportAst result;
        if (command.equals(this.previousCommand)) {
            return this.previousResult;
        }
        if (command.startsWith("import ")) {
            result = SCLExpressionCompiler.parseImportDeclaration((String)command);
        } else {
            CompositeModule environmentModule = this.createEnvironmentModule();
            result = SCLExpressionCompiler.compileCommand(CONTEXTUAL_COMPUTATION, (SCLValueCache)SCLOsgi.INSTANCE.getValueCache(), (Type[])new Type[]{Types.metaVar((Kind)Kinds.STAR)}, (CommandLanguageDescription)LANGUAGE_DESCRIPTION, (ClassLoader)SCLOsgi.INSTANCE.getClassLoader(), (CompositeModule)environmentModule, (String)command);
        }
        this.previousCommand = command;
        this.previousResult = result;
        return result;
    }

    public SCLError[] validate(String command) {
        try {
            this.compile(command);
            return SCLError.EMPTY_ARRAY;
        }
        catch (SCLExpressionCompilationException e) {
            return e.getErrors();
        }
    }

    public void setVariable(String name, Type type, Object value) {
        this.context.put((Object)name, value);
        this.contextTypes.put((Object)name, (Object)type);
    }

    public Object getVariableValue(String name) {
        return this.context.get((Object)name);
    }

    public Object getVariableType(String name) {
        return this.contextTypes.get((Object)name);
    }

    public void removeVariable(String name) {
        this.context.remove((Object)name);
        this.contextTypes.remove((Object)name);
    }

    public CommandResponse executeInJob(String command) {
        this.PRINT_COMMANDS = Boolean.parseBoolean(System.getProperty("scl.debug.print.commands", "false"));
        if (this.PRINT_COMMANDS) {
            System.err.println(command);
        }
        if (this.job != null) {
            this.job.setName(command);
        }
        try {
            CommandResponse commandResponse = this.execute(command);
            return commandResponse;
        }
        finally {
            if (this.job != null) {
                this.job.setName("");
            }
        }
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public CommandResponse execute(String command) {
        try {
            Object result;
            SCLContext.getCurrent().put((Object)"compilationErrorHandler", (Object)this.compilationErrorHandler);
            try {
                result = this.compile(command);
            }
            catch (SCLExpressionCompilationException e) {
                return new CommandResponse(SCLErrorFormatter.toString((Source)new StringSource("Expression", command), (SCLError[])e.getErrors()), true);
            }
            if (result instanceof CompiledCommand) {
                CompiledCommand computation = (CompiledCommand)result;
                SCLContext.getCurrent().put((Object)"printer", (Object)this.printer);
                String response = (String)((ContextualComputation)computation.command).execute(this.context);
                this.contextTypes.putAll(computation.storedVariables);
                return new CommandResponse(response, false);
            }
            if (result instanceof DImportAst) {
                DImportAst import_ = (DImportAst)result;
                Module module = SCLOsgi.INSTANCE.getModuleLoader().loadModule(import_.moduleName);
                if (module == null) {
                    return new CommandResponse("Did not find module " + import_.moduleName + ".", true);
                }
                this.imports.add(new Import(import_.localName, module));
                return new CommandResponse("", false);
            }
            return new CommandResponse("Invalid command.", true);
        }
        catch (Throwable e) {
            return new CommandResponse(SCLCommandSession.formatException(e), true);
        }
    }

    private static String formatException(Throwable e) {
        StringBuilder b = new StringBuilder();
        SCLCommandSession.formatException(b, null, e);
        return b.toString();
    }

    private static void formatException(StringBuilder b, StackTraceElement[] enclosingTrace, Throwable e) {
        String className;
        StackTraceElement element;
        int i;
        int endPos;
        StackTraceElement[] elements;
        block15: {
            elements = e.getStackTrace();
            Throwable cause = e.getCause();
            if (cause != null) {
                SCLCommandSession.formatException(b, elements, cause);
                b.append("Rethrown as ");
            }
            b.append(e).append('\n');
            endPos = elements.length;
            if (enclosingTrace != null) {
                int p = enclosingTrace.length;
                while (endPos > 0 && p > 0 && elements[endPos - 1].equals(enclosingTrace[p - 1])) {
                    --p;
                    --endPos;
                }
            } else {
                i = 0;
                while (i < endPos) {
                    element = elements[i];
                    if (element.getMethodName().equals("execute") && element.getClassName().equals(THIS_CLASS_NAME)) {
                        endPos = i;
                        while (endPos > 0) {
                            element = elements[endPos - 1];
                            className = element.getClassName();
                            if (className.startsWith("org.simantics.scl.compiler.top.SCLExpressionCompiler") || className.startsWith("org.simantics.scl.runtime.function.FunctionImpl")) {
                                --endPos;
                                continue;
                            }
                            break block15;
                        }
                        break;
                    }
                    ++i;
                }
            }
        }
        i = 0;
        while (i < endPos) {
            element = elements[i];
            className = element.getClassName();
            if (!(className.equals("org.simantics.scl.compiler.interpreted.IApply") || className.equals("org.simantics.scl.compiler.interpreted.ILet") || className.startsWith("tempsclpackage"))) {
                if (className.startsWith("org.simantics.scl.compiler.interpreted.ILambda")) {
                    b.append("\tat command line\n");
                } else {
                    String fileName;
                    String methodName = element.getMethodName();
                    if (!(className.startsWith("org.simantics.scl.runtime.function.FunctionImpl") && methodName.equals("applyArray") || "_SCL_Closure".equals(fileName = element.getFileName()))) {
                        b.append("\tat ");
                        if ("_SCL_Module".equals(fileName) || "_SCL_TypeClassInstance".equals(fileName)) {
                            b.append(NameMangling.demangle((String)methodName)).append('(').append(element.getLineNumber()).append(')');
                        } else {
                            b.append(element);
                        }
                        b.append('\n');
                    }
                }
            }
            ++i;
        }
    }

    public void addImport(String localName, String moduleName) throws CommandExecutionException {
        SCLContext.getCurrent().put((Object)"compilationErrorHandler", (Object)this.compilationErrorHandler);
        Module module = SCLOsgi.INSTANCE.getModuleLoader().loadModule(moduleName);
        if (module == null) {
            throw new CommandExecutionException("Did not find module " + moduleName + ".");
        }
        this.imports.add(new Import(localName, module));
    }

    private static String trimEnd(String text) {
        int l = text.length();
        while (l > 0) {
            char c = text.charAt(l - 1);
            if (c != ' ' && c != '\n' && c != '\r') break;
            --l;
        }
        return text.substring(0, l);
    }

    public void runFromFile(String fileName) {
        block5: {
            FileInputStream stream = null;
            try {
                try {
                    stream = new FileInputStream(fileName);
                    CommandScriptExecutor exec = new CommandScriptExecutor(new InputStreamReader(stream));
                    exec.execute(new TObjectProcedure<String>(){

                        public boolean execute(String command) {
                            String message;
                            CommandResponse response = SCLCommandSession.this.execute(command);
                            if (response.message != null && !(message = SCLCommandSession.trimEnd(response.message)).isEmpty()) {
                                SCLCommandSession.this.printer.print(message);
                            }
                            return true;
                        }
                    });
                }
                catch (IOException e) {
                    this.printer.print(e.getMessage());
                    SCLCommandSession.uncheckedClose(stream);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                SCLCommandSession.uncheckedClose(stream);
                throw throwable;
            }
            SCLCommandSession.uncheckedClose(stream);
        }
    }

    public void runFromFile(String fileName, final RunFromFileProgressMonitor monitor) {
        FileInputStream stream;
        try {
            stream = new FileInputStream(fileName);
        }
        catch (IOException e) {
            monitor.error(e);
            return;
        }
        try {
            try {
                CommandScriptExecutor exec = new CommandScriptExecutor(new InputStreamReader(stream));
                final long totalLength = new File(fileName).length();
                exec.execute(new TObjectProcedure<String>(){
                    long progress = 0L;

                    public boolean execute(String command) {
                        if (!monitor.start(command, (double)this.progress / (double)totalLength)) {
                            return false;
                        }
                        this.progress += (long)(command.length() + 1);
                        CommandResponse response = SCLCommandSession.this.execute(command);
                        if (response.error) {
                            monitor.error(SCLCommandSession.trimEnd(response.message));
                        }
                        return true;
                    }
                });
            }
            catch (Exception e) {
                monitor.error(e);
                SCLCommandSession.uncheckedClose(stream);
            }
        }
        finally {
            SCLCommandSession.uncheckedClose(stream);
        }
    }

    private void runTestFile(String fileName) {
        block6: {
            BufferedInputStream stream = null;
            try {
                try {
                    SCLCommandSession session = new SCLCommandSession(new Printer(){

                        public void print(String text) {
                            System.err.println(text);
                        }
                    });
                    stream = new BufferedInputStream(new FileInputStream(fileName));
                    TestScriptExecutor executor = new TestScriptExecutor(new InputStreamReader(stream), session);
                    TestScriptExecutor.ExecutionError error = executor.execute();
                    ((InputStream)stream).close();
                    if (error != null && !error.expectedResponse.equals(error.actualResponse)) {
                        throw new AssertionError((Object)("[Line " + executor.getExecutedLines() + "] while executing command: " + error.command + " expected '" + error.expectedResponse + "' got '" + error.actualResponse + "'"));
                    }
                }
                catch (IOException e) {
                    this.printer.print(e.getMessage());
                    SCLCommandSession.uncheckedClose(stream);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SCLCommandSession.uncheckedClose(stream);
                throw throwable;
            }
            SCLCommandSession.uncheckedClose(stream);
        }
    }

    private void runTest(String testName) {
        try {
            String[] paths;
            String pathProperty = System.getProperty("scl.test.path");
            String[] stringArray = paths = pathProperty != null ? pathProperty.split(";") : null;
            if (pathProperty == null) {
                String SCLPATH = System.getenv("SCLPATH");
                paths = SCLPATH.split(";");
            }
            String[] stringArray2 = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                File file;
                String path = stringArray2[n2];
                String testPath = String.valueOf(path) + "\\" + testName;
                if (!testPath.endsWith(".sts")) {
                    testPath = String.valueOf(testPath) + ".sts";
                }
                if ((file = new File(testPath)).exists()) {
                    BufferedInputStream stream = new BufferedInputStream(new FileInputStream(testPath));
                    try {
                        TestScriptExecutor executor = new TestScriptExecutor(new InputStreamReader(stream), this);
                        TestScriptExecutor.ExecutionError error = executor.execute();
                        ((InputStream)stream).close();
                        if (error != null && !error.expectedResponse.equals(error.actualResponse)) {
                            throw new AssertionError((Object)("[Line " + executor.getExecutedLines() + "] while executing command: " + error.command + " expected '" + error.expectedResponse + "' got '" + error.actualResponse + "'"));
                        }
                    }
                    finally {
                        SCLCommandSession.uncheckedClose(stream);
                    }
                    return;
                }
                this.printer.print("No such test : " + testName);
                ++n2;
            }
        }
        catch (IOException e) {
            this.printer.print(e.getMessage());
        }
    }

    private void reset() {
        this.imports.clear();
        this.initializeContext();
        SCLOsgi.reset();
    }

    private static void uncheckedClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static class Import {
        String namespace;
        Module module;

        public Import(String namespace, Module module) {
            this.namespace = namespace;
            this.module = module;
        }
    }

    public static interface RunFromFileProgressMonitor {
        public boolean start(String var1, double var2);

        public void error(String var1);

        public void error(Exception var1);
    }
}

