/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.osgi;

import gnu.trove.procedure.TObjectProcedure;
import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.runtime.jobs.Job;

public class CommandScriptExecutor {
    Job job;
    Reader reader;
    String nextLine;

    public CommandScriptExecutor(Reader reader) {
        this.reader = reader;
    }

    public CommandScriptExecutor(Reader reader, Job job) {
        this.reader = reader;
        this.job = job;
    }

    void pushBackLine(String line) {
        if (this.nextLine != null) {
            throw new IllegalStateException();
        }
        this.nextLine = line;
    }

    String readLine() throws IOException {
        if (this.nextLine != null) {
            String result = this.nextLine;
            this.nextLine = null;
            return result;
        }
        StringBuilder b = new StringBuilder();
        while (true) {
            int c;
            if ((c = this.reader.read()) <= 0) {
                if (b.length() != 0) break;
                return null;
            }
            if (c == 10) break;
            b.append((char)c);
        }
        return b.toString();
    }

    String readCommand() throws IOException {
        StringBuilder command = new StringBuilder();
        int firstIndentation = -1;
        while (true) {
            String line;
            if ((line = this.readLine()) == null) {
                if (firstIndentation < 0) {
                    return null;
                }
                return command.toString();
            }
            int indentation = 0;
            while (indentation < line.length() && line.charAt(indentation) == ' ') {
                ++indentation;
            }
            if (firstIndentation < 0) {
                firstIndentation = indentation;
            } else {
                if (indentation <= firstIndentation) {
                    this.pushBackLine(line);
                    return command.toString();
                }
                command.append('\n');
            }
            command.append(line.substring(firstIndentation));
        }
    }

    public void execute(TObjectProcedure<String> callback) throws IOException {
        String command;
        do {
            if ((command = this.readCommand()) != null) continue;
            return;
        } while (callback.execute((Object)command));
    }
}

