/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.wizard;

import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.VersionMap;
import org.simantics.db.common.utils.Versions;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteResult;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.wizard.MigrateModel;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.workbench.dialogs.ResourceSelectionDialog3;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.strings.AlphanumComparator;

public class MigrateWizard
extends Wizard {
    final String initial;
    MigratePage migratePage;
    IEclipsePreferences prefnode;
    private static final Comparator<MigrateModel.MigrationOperation> MIGRATION_OP_COMPARATOR = new Comparator<MigrateModel.MigrationOperation>(){

        @Override
        public int compare(MigrateModel.MigrationOperation o1, MigrateModel.MigrationOperation o2) {
            return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)o1.nr.getName(), (Object)o2.nr.getName());
        }
    };

    public MigrateWizard(String initial) {
        this.initial = initial;
        this.setWindowTitle("Perform migration");
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(false);
        this.prefnode = InstanceScope.INSTANCE.getNode("org.simantics.modeling.ui.wizard.MigrateWizard");
    }

    public void addPages() {
        this.migratePage = new MigratePage(this.initial);
        this.addPage((IWizardPage)this.migratePage);
    }

    public boolean canFinish() {
        return true;
    }

    public boolean performFinish() {
        int locationIndex = this.migratePage.locations.getSelectionIndex();
        if (locationIndex == -1) {
            return true;
        }
        if (this.migratePage.model == null || this.migratePage.model.instances.isEmpty()) {
            return true;
        }
        int[] sel = this.migratePage.instances.getSelectionIndices();
        TIntHashSet sels = new TIntHashSet();
        int[] nArray = sel;
        int n = sel.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            sels.add(i);
            ++n2;
        }
        List<MigrateModel.MigrationOperation> ops = this.migratePage.model.sortedShownInstances;
        int index = 0;
        final ArrayList<MigrateModel.MigrationOperation> result = new ArrayList<MigrateModel.MigrationOperation>();
        for (MigrateModel.MigrationOperation op : ops) {
            if (sels.contains(index)) {
                result.add(op);
            }
            ++index;
        }
        if (result.isEmpty()) {
            return true;
        }
        try {
            String report = (String)Simantics.getSession().syncRequest((WriteResult)new WriteResultRequest<String>(){

                public String perform(WriteGraph graph) throws DatabaseException {
                    StringBuilder b = new StringBuilder();
                    int success = 0;
                    int problem = 0;
                    for (MigrateModel.MigrationOperation op : result) {
                        String problems = op.perform(graph);
                        if (problems != null) {
                            b.insert(0, problems);
                            b.insert(0, String.valueOf(op.getDescription((ReadGraph)graph)) + "\n");
                            ++problem;
                            continue;
                        }
                        b.append(String.valueOf(op.getDescription((ReadGraph)graph)) + "\n");
                        b.append(" success\n");
                        ++success;
                    }
                    int total = success + problem;
                    b.insert(0, "---------------------\n");
                    b.insert(0, "Details:\n");
                    b.insert(0, "\n");
                    b.insert(0, "  OK: " + success + "\n");
                    b.insert(0, "  Failure: " + problem + "\n");
                    b.insert(0, "---------------------\n");
                    b.insert(0, "Performed migration for " + total + " instances:\n");
                    return b.toString();
                }
            });
            class InfoMessageDialog
            extends MessageDialog {
                private final /* synthetic */ String val$report;

                public InfoMessageDialog(Shell shell, String string) {
                    this.val$report = string;
                    super(shell, "Migration report", null, "", 2, new String[]{"Continue"}, 0);
                }

                protected boolean isResizable() {
                    return true;
                }

                protected Point getInitialSize() {
                    return new Point(800, 500);
                }

                protected Control createCustomArea(Composite composite) {
                    GridLayoutFactory.fillDefaults().applyTo(composite);
                    Text text = new Text(composite, 2570);
                    text.setText(this.val$report);
                    GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)text);
                    return composite;
                }
            }
            InfoMessageDialog md = new InfoMessageDialog(Display.getCurrent().getActiveShell(), report);
            md.open();
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
        return true;
    }

    class MigratePage
    extends WizardPage {
        String initial;
        MigrateModel model;
        Text source;
        Button browseSource;
        Text target;
        Button browseTarget;
        CCombo locations;
        org.eclipse.swt.widgets.List instances;
        Listener validateListener;

        public MigratePage(String initial) {
            super("Perform migration", "Perform migration", null);
            this.validateListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 24: {
                            MigratePage.this.validatePage();
                        }
                        case 13: {
                            MigratePage.this.validatePage();
                            break;
                        }
                        case 15: {
                            if (!(event.widget instanceof Text)) break;
                            Text t = (Text)event.widget;
                            t.selectAll();
                        }
                    }
                }
            };
            this.initial = initial;
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 20;
            layout.verticalSpacing = 10;
            layout.numColumns = 10;
            container.setLayout((Layout)layout);
            new Label(container, 0).setText("&Source:");
            this.source = new Text(container, 2048);
            this.source.setText(this.initial);
            this.source.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MigratePage.this.refreshModel();
                    if (MigratePage.this.locations.getItemCount() > 0) {
                        MigratePage.this.locations.select(0);
                    }
                    MigratePage.this.refreshInstances();
                }
            });
            GridDataFactory.fillDefaults().grab(true, false).span(8, 1).applyTo((Control)this.source);
            this.browseSource = new Button(container, 0);
            this.browseSource.setText("&Browse");
            GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.browseSource);
            this.browseSource.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                }

                public void widgetDefaultSelected(SelectionEvent e_) {
                    final String targetText = MigratePage.this.target.getText();
                    try {
                        String uri;
                        Map map = (Map)Simantics.getSession().syncRequest((Read)new UniqueRead<Map<String, Pair<String, ImageDescriptor>>>(){

                            public Map<String, Pair<String, ImageDescriptor>> perform(ReadGraph graph) throws DatabaseException {
                                Resource target = graph.getPossibleResource(targetText);
                                if (target == null) {
                                    return null;
                                }
                                HashMap<String, Pair<String, ImageDescriptor>> result = new HashMap<String, Pair<String, ImageDescriptor>>();
                                Collection infos = Versions.getOlderVersions((ReadGraph)graph, (Resource)target);
                                for (NamedResource info : infos) {
                                    result.put(graph.getURI(info.getResource()), (Pair<String, ImageDescriptor>)Pair.make((Object)Versions.getStandardPathNameString((ReadGraph)graph, (Resource)info.getResource()), null));
                                }
                                return result;
                            }
                        });
                        Shell shell = MigratePage.this.target.getShell();
                        ResourceSelectionDialog3<String> dialog = new ResourceSelectionDialog3<String>(shell, map, "Select source type", false){

                            protected IDialogSettings getBaseDialogSettings() {
                                return Activator.getDefault().getDialogSettings();
                            }
                        };
                        if (dialog.open() == 0 && (uri = (String)dialog.getFirstResult()) != null) {
                            MigratePage.this.source.setText(uri);
                        }
                    }
                    catch (DatabaseException e) {
                        Logger.defaultLogError((Throwable)e);
                    }
                }
            });
            new Label(container, 0).setText("&Target:");
            this.target = new Text(container, 2048);
            this.target.setText(this.initial);
            this.target.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MigratePage.this.refreshModel();
                    if (MigratePage.this.locations.getItemCount() > 0) {
                        MigratePage.this.locations.select(0);
                    }
                    MigratePage.this.refreshInstances();
                }
            });
            GridDataFactory.fillDefaults().grab(true, false).span(8, 1).applyTo((Control)this.target);
            this.browseTarget = new Button(container, 0);
            this.browseTarget.setText("B&rowse");
            GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.browseTarget);
            this.browseTarget.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                }

                public void widgetDefaultSelected(SelectionEvent e_) {
                    final String sourceText = MigratePage.this.source.getText();
                    try {
                        String uri;
                        Map map = (Map)Simantics.getSession().syncRequest((Read)new UniqueRead<Map<String, Pair<String, ImageDescriptor>>>(){

                            public Map<String, Pair<String, ImageDescriptor>> perform(ReadGraph graph) throws DatabaseException {
                                Resource source = graph.getPossibleResource(sourceText);
                                if (source == null) {
                                    return null;
                                }
                                HashMap<String, Pair<String, ImageDescriptor>> result = new HashMap<String, Pair<String, ImageDescriptor>>();
                                Collection infos = Versions.getNewerVersions((ReadGraph)graph, (Resource)source);
                                for (NamedResource info : infos) {
                                    result.put(graph.getURI(info.getResource()), (Pair<String, ImageDescriptor>)Pair.make((Object)Versions.getStandardPathNameString((ReadGraph)graph, (Resource)info.getResource()), null));
                                }
                                return result;
                            }
                        });
                        Shell shell = MigratePage.this.source.getShell();
                        ResourceSelectionDialog3<String> dialog = new ResourceSelectionDialog3<String>(shell, map, "Select target type", false){

                            protected IDialogSettings getBaseDialogSettings() {
                                return Activator.getDefault().getDialogSettings();
                            }
                        };
                        if (dialog.open() == 0 && (uri = (String)dialog.getFirstResult()) != null) {
                            MigratePage.this.target.setText(uri);
                        }
                    }
                    catch (DatabaseException e) {
                        Logger.defaultLogError((Throwable)e);
                    }
                }
            });
            new Label(container, 0).setText("&Locations:");
            this.locations = new CCombo(container, 2056);
            this.locations.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MigratePage.this.refreshInstances();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    MigratePage.this.refreshInstances();
                }
            });
            GridDataFactory.fillDefaults().grab(true, false).span(9, 1).applyTo((Control)this.locations);
            Label horizRule = new Label(container, 0);
            GridDataFactory.fillDefaults().hint(-1, 0).indent(0, 20).grab(true, false).span(30, 1).applyTo((Control)horizRule);
            Label l = new Label(container, 0);
            l.setText("&Select instances to migrate:");
            GridDataFactory.fillDefaults().grab(true, false).span(10, 1).applyTo((Control)l);
            this.instances = new org.eclipse.swt.widgets.List(container, 2626);
            GridDataFactory.fillDefaults().grab(true, true).span(10, 1).applyTo((Control)this.instances);
            this.instances.addListener(24, this.validateListener);
            Composite buttonBar = new Composite(container, 0);
            RowLayoutFactory.fillDefaults().type(256).applyTo(buttonBar);
            GridDataFactory.fillDefaults().grab(true, false).span(10, 1).applyTo((Control)buttonBar);
            Button selectAll = new Button(buttonBar, 8);
            selectAll.setText("Select &All");
            Button selectNone = new Button(buttonBar, 8);
            selectNone.setText("Select &None");
            selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MigratePage.this.instances.selectAll();
                }
            });
            selectNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MigratePage.this.instances.deselectAll();
                }
            });
            this.refreshModel();
            if (this.locations.getItemCount() > 0) {
                this.locations.select(0);
            }
            this.refreshInstances();
            this.setControl((Control)container);
            this.validatePage();
        }

        void refreshModel() {
            final String sourceText = this.source.getText();
            final String targetText = this.target.getText();
            try {
                this.model = (MigrateModel)Simantics.getSession().syncRequest((Read)new UniqueRead<MigrateModel>(){

                    public Collection<NamedResource> getLocations(ReadGraph graph, Resource project) throws DatabaseException {
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                        ArrayList<NamedResource> libraries = new ArrayList<NamedResource>();
                        for (Resource r : (Collection)graph.syncRequest((Read)new ObjectsWithType(project, L0.ConsistsOf, SIMU.Model))) {
                            String name = Versions.getStandardNameString((ReadGraph)graph, (Resource)r);
                            libraries.add(new NamedResource(name, r));
                        }
                        Collection ontologies = (Collection)Simantics.applySCL((String)"Simantics/SharedOntologies", (String)"traverseSharedOntologies", (ReadGraph)graph, (Object[])new Object[]{graph.getRootLibrary()});
                        for (Resource r : ontologies) {
                            String name = Versions.getStandardNameString((ReadGraph)graph, (Resource)r);
                            libraries.add(new NamedResource(name, r));
                        }
                        return libraries;
                    }

                    private Pair<String, Integer> addInstance(MapList<NamedResource, MigrateModel.MigrationOperation> list, ReadGraph graph, Resource instance, MigrateModel.MigrationOperation op) throws DatabaseException {
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        if (graph.isInstanceOf(instance, L0.IndexRoot)) {
                            return Pair.make((Object)"", (Object)0);
                        }
                        if ((instance = graph.getPossibleObject(instance, L0.PartOf)) == null) {
                            return Pair.make((Object)"", (Object)0);
                        }
                        String name = Versions.getStandardNameString((ReadGraph)graph, (Resource)instance);
                        Pair<String, Integer> parent = this.addInstance(list, graph, instance, op);
                        String code = String.valueOf((String)parent.first) + "\u00a4" + name + " \u00a4\u00a4\u00a4";
                        int i = 0;
                        while (i < (Integer)parent.second) {
                            code = String.valueOf(code) + " ";
                            ++i;
                        }
                        code = String.valueOf(code) + name;
                        list.add((Object)new NamedResource(code, instance), (Object)op);
                        return Pair.make((Object)(String.valueOf((String)parent.first) + "\u00a4" + name), (Object)((Integer)parent.second + 2));
                    }

                    private MigrateModel getComponentTypeModel(ReadGraph graph, Resource source, Resource target) throws DatabaseException {
                        MigrateModel model = new MigrateModel();
                        MapList list = new MapList();
                        Instances query = (Instances)graph.adapt(source, Instances.class);
                        HashSet instances = new HashSet();
                        for (NamedResource nr : this.getLocations(graph, Simantics.getProjectResource())) {
                            Collection found = query.find(graph, nr.getResource());
                            instances.addAll(found);
                        }
                        for (Resource instance : instances) {
                            String uri = graph.getPossibleURI(instance);
                            MigrateModel.MigrationOperation op = new MigrateModel.MigrationOperation(new NamedResource(uri, instance), new NamedResource("", target));
                            this.addInstance((MapList<NamedResource, MigrateModel.MigrationOperation>)list, graph, instance, op);
                        }
                        ArrayList keys = new ArrayList(list.getKeys());
                        Collections.sort(keys);
                        for (NamedResource key : keys) {
                            List ops = list.getValuesSnapshot((Object)key);
                            String[] parts = key.getName().split("\u00a4\u00a4\u00a4");
                            model.instances.add((Pair<NamedResource, Collection<MigrateModel.MigrationOperation>>)Pair.make((Object)new NamedResource(parts[1], key.getResource()), (Object)ops));
                        }
                        return model;
                    }

                    public NamedResource matchBest(ReadGraph graph, Resource type, Resource newOntology) throws DatabaseException {
                        VersionMap versions = Versions.match((ReadGraph)graph, (Resource)type, (Resource)newOntology);
                        return versions.getNewest(graph, Versions.getBaseName((ReadGraph)graph, (Resource)type));
                    }

                    private MigrateModel getSharedOntologyModel(ReadGraph graph, Resource source, Resource target) throws DatabaseException {
                        MigrateModel model = new MigrateModel();
                        MapList list = new MapList();
                        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                        Instances query = (Instances)graph.adapt(STR.ComponentType, Instances.class);
                        HashSet<Resource> types = new HashSet<Resource>();
                        for (Resource type : query.find(graph, source)) {
                            Resource root;
                            if (graph.isInheritedFrom(type, DIA.Element) || !source.equals(root = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(type)))) continue;
                            types.add(type);
                        }
                        HashSet instances = new HashSet();
                        Collection<NamedResource> locations = this.getLocations(graph, Simantics.getProjectResource());
                        for (Resource type : types) {
                            Instances query2 = (Instances)graph.adapt(type, Instances.class);
                            for (NamedResource nr : locations) {
                                Collection found = query2.find(graph, nr.getResource());
                                instances.addAll(found);
                            }
                        }
                        for (Resource instance : instances) {
                            Resource type = graph.getPossibleType(instance, STR.Component);
                            String uri = graph.getPossibleURI(instance);
                            NamedResource best = this.matchBest(graph, type, target);
                            if (best == null) continue;
                            MigrateModel.MigrationOperation op = new MigrateModel.MigrationOperation(new NamedResource(uri, instance), best);
                            this.addInstance((MapList<NamedResource, MigrateModel.MigrationOperation>)list, graph, instance, op);
                        }
                        ArrayList keys = new ArrayList(list.getKeys());
                        Collections.sort(keys);
                        for (NamedResource key : keys) {
                            List ops = list.getValues((Object)key);
                            String[] parts = key.getName().split("\u00a4\u00a4\u00a4");
                            model.instances.add((Pair<NamedResource, Collection<MigrateModel.MigrationOperation>>)Pair.make((Object)new NamedResource(parts[1], key.getResource()), (Object)ops));
                        }
                        return model;
                    }

                    public MigrateModel perform(ReadGraph graph) throws DatabaseException {
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                        Resource source = graph.getPossibleResource(sourceText);
                        if (source == null) {
                            return MigratePage.this.model;
                        }
                        Resource target = graph.getPossibleResource(targetText);
                        if (target == null) {
                            return MigratePage.this.model;
                        }
                        if (graph.isInstanceOf(source, STR.ComponentType)) {
                            return this.getComponentTypeModel(graph, source, target);
                        }
                        if (graph.isInstanceOf(source, L0.SharedOntology)) {
                            return this.getSharedOntologyModel(graph, source, target);
                        }
                        return null;
                    }
                });
            }
            catch (DatabaseException e) {
                Logger.defaultLogError((Throwable)e);
            }
            this.instances.removeAll();
            this.locations.removeAll();
            if (this.model == null) {
                return;
            }
            for (Pair<NamedResource, Collection<MigrateModel.MigrationOperation>> r : this.model.instances) {
                this.locations.add(String.valueOf(((NamedResource)r.first).getName()) + " (" + ((Collection)r.second).size() + " instances)");
            }
            if (this.locations.getItemCount() == 0) {
                this.locations.add("<no instances were found>");
                this.locations.select(0);
            }
        }

        void refreshInstances() {
            if (this.model == null || this.model.instances.isEmpty()) {
                return;
            }
            this.instances.removeAll();
            int locationIndex = this.locations.getSelectionIndex();
            if (locationIndex == -1) {
                return;
            }
            this.model.sortedShownInstances = new ArrayList<MigrateModel.MigrationOperation>();
            for (MigrateModel.MigrationOperation o : (Collection)this.model.instances.get((int)locationIndex).second) {
                this.model.sortedShownInstances.add(o);
            }
            Collections.sort(this.model.sortedShownInstances, MIGRATION_OP_COMPARATOR);
            for (MigrateModel.MigrationOperation o : this.model.sortedShownInstances) {
                this.instances.add(o.toString());
            }
        }

        private void validatePage() {
            this.setMessage(null);
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }
}

