/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.ObjectUtils;
import org.simantics.utils.datastructures.Pair;

public class MigrateModel {
    public List<Pair<NamedResource, Collection<MigrationOperation>>> instances = new ArrayList<Pair<NamedResource, Collection<MigrationOperation>>>();
    public List<MigrationOperation> sortedShownInstances = Collections.emptyList();

    public static class MigrationOperation {
        public NamedResource nr;
        public NamedResource targetType;

        public MigrationOperation(NamedResource nr, NamedResource targetType) {
            this.nr = nr;
            this.targetType = targetType;
        }

        public String toString() {
            return this.nr.getName();
        }

        public String getDescription(ReadGraph graph) throws DatabaseException {
            String sourceURI = graph.getPossibleURI(this.nr.getResource());
            if (sourceURI == null) {
                sourceURI = NameUtils.getSafeName((ReadGraph)graph, (Resource)this.nr.getResource());
            }
            sourceURI = sourceURI.replace("http://Projects/Development%20Project/", "");
            String targetURI = graph.getURI(this.targetType.getResource());
            return String.valueOf(sourceURI) + " into " + targetURI;
        }

        private Resource getPossibleReplacement(ReadGraph graph, Resource type, Resource predicate) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            String name = (String)graph.getPossibleRelatedValue(predicate, L0.HasName, (Binding)Bindings.STRING);
            if (name == null) {
                return null;
            }
            return Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)type, (String)name);
        }

        public String replace(WriteGraph graph, Resource resource, Resource target) throws DatabaseException {
            Resource replacement;
            Resource predicate;
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            StringBuilder problems = new StringBuilder();
            for (Statement stm : graph.getStatements(resource, L0.IsWeaklyRelatedTo)) {
                Collection replacementConnectionTypes;
                HashSet replacementSet;
                String name;
                predicate = stm.getPredicate();
                if (stm.isAsserted(resource)) continue;
                if (graph.isInstanceOf(predicate, STR.Property)) {
                    String replacementValueType;
                    replacement = this.getPossibleReplacement((ReadGraph)graph, target, predicate);
                    if (replacement == null) continue;
                    if (!graph.isInstanceOf(replacement, STR.Property)) {
                        name = (String)graph.getRelatedValue(predicate, L0.HasName, (Binding)Bindings.STRING);
                        problems.append(" " + name + " was a property in the source type\n");
                        continue;
                    }
                    String sourceValueType = (String)graph.getPossibleRelatedValue(predicate, L0.RequiresValueType, (Binding)Bindings.STRING);
                    if (!ObjectUtils.objectEquals((Object)sourceValueType, (Object)(replacementValueType = (String)graph.getPossibleRelatedValue(replacement, L0.RequiresValueType, (Binding)Bindings.STRING)))) {
                        String name2 = (String)graph.getRelatedValue(predicate, L0.HasName, (Binding)Bindings.STRING);
                        problems.append(" value types for property " + name2 + " differ (" + sourceValueType + " vs. " + replacementValueType + ")\n");
                        continue;
                    }
                }
                if (!graph.isInstanceOf(predicate, STR.ConnectionRelation)) continue;
                replacement = this.getPossibleReplacement((ReadGraph)graph, target, predicate);
                if (replacement == null) {
                    name = (String)graph.getRelatedValue(predicate, L0.HasName, (Binding)Bindings.STRING);
                    problems.append(" used connection point " + name + " has been removed from target type\n");
                    continue;
                }
                if (!graph.isInstanceOf(replacement, STR.ConnectionRelation)) {
                    name = (String)graph.getRelatedValue(predicate, L0.HasName, (Binding)Bindings.STRING);
                    problems.append(" " + name + " was a connection point in the source type\n");
                    continue;
                }
                Collection sourceConnetionTypes = graph.getObjects(predicate, STR.AllowsConnectionType);
                HashSet sourceSet = new HashSet(sourceConnetionTypes);
                if (sourceSet.equals(replacementSet = new HashSet(replacementConnectionTypes = graph.getObjects(replacement, STR.AllowsConnectionType)))) continue;
                String name3 = (String)graph.getRelatedValue(predicate, L0.HasName, (Binding)Bindings.STRING);
                problems.append(" allowed connection types for connection point " + name3 + " differ (" + NameUtils.getSafeName((ReadGraph)graph, sourceSet) + " vs. " + NameUtils.getSafeName((ReadGraph)graph, replacementSet) + ")\n");
            }
            if (problems.length() > 0) {
                return problems.toString();
            }
            for (Statement stm : graph.getStatements(resource, L0.IsWeaklyRelatedTo)) {
                predicate = stm.getPredicate();
                if (stm.isAsserted(resource)) continue;
                if (L0.InstanceOf.equals(predicate)) {
                    graph.deny(stm);
                    graph.claim(resource, L0.InstanceOf, target);
                }
                if (!graph.isInstanceOf(predicate, STR.Property) && !graph.isInstanceOf(predicate, STR.ConnectionRelation)) continue;
                replacement = this.getPossibleReplacement((ReadGraph)graph, target, predicate);
                graph.deny(stm);
                if (replacement == null) continue;
                graph.claim(stm.getSubject(), replacement, stm.getObject());
            }
            return null;
        }

        public String perform(WriteGraph graph) throws DatabaseException {
            Resource targetSymbol;
            Resource target;
            Resource resource = this.nr.getResource();
            String result = this.replace(graph, resource, target = this.targetType.getResource());
            if (result != null) {
                return result;
            }
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            Resource element = graph.getPossibleObject(resource, MOD.ComponentToElement);
            if (element != null && (targetSymbol = graph.getPossibleObject(target, MOD.ComponentTypeToSymbol)) != null && (result = this.replace(graph, element, targetSymbol)) != null) {
                return result;
            }
            return null;
        }
    }
}

