/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultBodyDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.reorder.RowReorderLayer;
import org.eclipse.nebula.widgets.nattable.resize.action.AutoResizeColumnAction;
import org.eclipse.nebula.widgets.nattable.resize.action.ColumnResizeCursorAction;
import org.eclipse.nebula.widgets.nattable.resize.event.ColumnResizeEventMatcher;
import org.eclipse.nebula.widgets.nattable.resize.mode.ColumnResizeDragMode;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.config.DefaultSelectionStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.action.ClearCursorAction;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.action.NoOpMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.DatabaseJob;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.URIStringUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleURI;
import org.simantics.db.request.Read;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.adapters.ChangeInformation;
import org.simantics.modeling.ui.view.Bean;
import org.simantics.modeling.ui.view.BeanSortModel;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.ResourceReferenceTransfer;
import org.simantics.ui.dnd.ResourceTransferUtils;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.utils.ui.dialogs.ShowMessage;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class ChangeInformationComposite
extends Composite {
    private final LocalResourceManager resourceManager;
    private final ColorDescriptor green = ColorDescriptor.createFrom((RGB)new RGB(87, 188, 149));
    private final Session session;
    private Resource resource;
    private List<Bean> allContents = new ArrayList<Bean>();
    private List<Bean> contents = new ArrayList<Bean>();
    protected Layer0 L0;
    protected IWorkbenchSite site;
    private NatTable table;
    private IDataProvider bodyDataProvider;
    private CDateTime createdBefore;
    private CDateTime createdAfter;
    private CDateTime modifiedBefore;
    private CDateTime modifiedAfter;
    private Label dropLabel;
    private Text creatorText;
    private Text modifierText;
    private Text nameText;
    private Text pathText;
    private Text typesText;
    private BeanSortModel sortModel;
    private static final String DONT_TOUCH = "DONT_TOUCH";

    public ChangeInformationComposite(Composite parent, int style, Session session, Resource resource, IWorkbenchSite site) {
        super(parent, style);
        Assert.isNotNull((Object)session, (String)"session is null");
        this.session = session;
        this.resource = resource;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.site = site;
    }

    protected void setStatus(String message, String error) {
        IStatusLineManager status = WorkbenchUtils.getStatusLine((IWorkbenchSite)this.site);
        if (status != null) {
            if (message != DONT_TOUCH) {
                status.setMessage(message);
            }
            if (error != DONT_TOUCH) {
                status.setErrorMessage(error);
            }
        }
    }

    public void defaultInitializeUI() {
        this.setLayout((Layout)new GridLayout(4, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.createDropLabel(this);
        this.createContents(this);
    }

    public Label createDropLabel(Composite parent) {
        this.dropLabel = new Label(parent, 2048);
        this.dropLabel.setAlignment(0x1000000);
        this.dropLabel.setText("Drag a resource here");
        this.dropLabel.setForeground(parent.getDisplay().getSystemColor(16));
        GridDataFactory.fillDefaults().align(4, 4).hint(-1, 20).span(4, 1).grab(true, false).applyTo((Control)this.dropLabel);
        DropTarget dropTarget = new DropTarget((Control)this.dropLabel, 5);
        dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance(), ResourceReferenceTransfer.getInstance(), LocalObjectTransfer.getTransfer()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 4;
                ChangeInformationComposite.this.dropLabel.setBackground((Color)ChangeInformationComposite.this.resourceManager.get((DeviceResourceDescriptor)ChangeInformationComposite.this.green));
            }

            public void dragLeave(DropTargetEvent event) {
                ChangeInformationComposite.this.dropLabel.setBackground(null);
            }

            public void drop(DropTargetEvent event) {
                ChangeInformationComposite.this.dropLabel.setBackground(null);
                ResourceArray[] data = this.parseEventData(event);
                if (data == null || data.length != 1) {
                    event.detail = 0;
                    return;
                }
                ResourceArray array = data[0];
                Resource r = array.resources[array.resources.length - 1];
                ChangeInformationComposite.this.changeLocation(r);
            }

            private ResourceArray[] parseEventData(DropTargetEvent event) {
                ResourceArray[] ret;
                if (event.data instanceof String) {
                    try {
                        SerialisationSupport support = (SerialisationSupport)ChangeInformationComposite.this.session.getService(SerialisationSupport.class);
                        return ResourceTransferUtils.readStringTransferable((SerialisationSupport)support, (String)((String)event.data)).toResourceArrayArray();
                    }
                    catch (IllegalArgumentException e) {
                        ErrorLogger.defaultLogError((Throwable)e);
                    }
                    catch (DatabaseException e) {
                        ErrorLogger.defaultLogError((Throwable)e);
                    }
                }
                if ((ret = ResourceAdaptionUtils.toResourceArrays((Object)event.data)).length > 0) {
                    return ret;
                }
                return null;
            }
        });
        return this.dropLabel;
    }

    public void createContents(Composite parent) {
        Group fieldGroup = new Group(parent, 0);
        fieldGroup.setLayout((Layout)new GridLayout(2, false));
        fieldGroup.setText("Filter modifications by text in columns");
        GridDataFactory.fillDefaults().align(4, 4).span(4, 1).grab(true, false).applyTo((Control)fieldGroup);
        Label label = new Label((Composite)fieldGroup, 0);
        label.setAlignment(0x1000000);
        label.setText("Created By:");
        GridDataFactory.fillDefaults().align(4, 4).hint(-1, 20).span(1, 1).grab(false, false).applyTo((Control)label);
        this.creatorText = new Text((Composite)fieldGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 4).hint(-1, 20).span(1, 1).grab(true, false).applyTo((Control)this.creatorText);
        this.creatorText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChangeInformationComposite.this.updateData(false);
            }
        });
        label = new Label((Composite)fieldGroup, 0);
        label.setAlignment(0x1000000);
        label.setText("Modified By:");
        GridDataFactory.fillDefaults().align(4, 4).hint(-1, 20).span(1, 1).grab(false, false).applyTo((Control)label);
        this.modifierText = new Text((Composite)fieldGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 4).hint(-1, 20).span(1, 1).grab(true, false).applyTo((Control)this.modifierText);
        this.modifierText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChangeInformationComposite.this.updateData(false);
            }
        });
        label = new Label((Composite)fieldGroup, 0);
        label.setAlignment(0x1000000);
        label.setText("Name:");
        GridDataFactory.fillDefaults().align(4, 4).hint(-1, 20).span(1, 1).grab(false, false).applyTo((Control)label);
        this.nameText = new Text((Composite)fieldGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 4).hint(-1, 20).span(1, 1).grab(true, false).applyTo((Control)this.nameText);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChangeInformationComposite.this.updateData(false);
            }
        });
        label = new Label((Composite)fieldGroup, 0);
        label.setAlignment(0x1000000);
        label.setText("Path:");
        GridDataFactory.fillDefaults().align(4, 4).hint(-1, 20).span(1, 1).grab(false, false).applyTo((Control)label);
        this.pathText = new Text((Composite)fieldGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 4).hint(-1, 20).span(1, 1).grab(true, false).applyTo((Control)this.pathText);
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChangeInformationComposite.this.updateData(false);
            }
        });
        label = new Label((Composite)fieldGroup, 0);
        label.setAlignment(0x1000000);
        label.setText("Types:");
        GridDataFactory.fillDefaults().align(4, 4).hint(-1, 20).span(1, 1).grab(false, false).applyTo((Control)label);
        this.typesText = new Text((Composite)fieldGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 4).hint(-1, 20).span(1, 1).grab(true, false).applyTo((Control)this.typesText);
        this.typesText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChangeInformationComposite.this.updateData(false);
            }
        });
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ChangeInformationComposite.this.updateData(false);
            }
        };
        Group timeGroup = new Group(parent, 0);
        timeGroup.setLayout((Layout)new GridLayout(2, false));
        timeGroup.setText("Filter modifications by time");
        GridDataFactory.fillDefaults().align(4, 4).span(4, 1).grab(true, false).applyTo((Control)timeGroup);
        this.createdAfter = new CDateTime((Composite)timeGroup, 0x10000003);
        this.createdAfter.setPattern("'Created after 'd.M.yyy '@' H:mm");
        this.createdAfter.setNullText("<choose created after>");
        this.createdAfter.addSelectionListener(selectionListener);
        GridDataFactory.fillDefaults().align(4, 4).hint(-1, 20).span(1, 1).grab(true, false).applyTo((Control)this.createdAfter);
        this.createdBefore = new CDateTime((Composite)timeGroup, 0x10000003);
        this.createdBefore.setPattern("'Created before 'd.M.yyy '@' H:mm");
        this.createdBefore.setNullText("<choose created before>");
        this.createdBefore.addSelectionListener(selectionListener);
        GridDataFactory.fillDefaults().align(4, 4).hint(-1, 20).span(1, 1).grab(true, false).applyTo((Control)this.createdBefore);
        this.modifiedAfter = new CDateTime((Composite)timeGroup, 0x10000003);
        this.modifiedAfter.setPattern("'Modified after 'd.M.yyy '@' H:mm");
        this.modifiedAfter.setNullText("<choose modified after>");
        this.modifiedAfter.addSelectionListener(selectionListener);
        GridDataFactory.fillDefaults().align(4, 4).hint(-1, 20).span(1, 1).grab(true, false).applyTo((Control)this.modifiedAfter);
        this.modifiedBefore = new CDateTime((Composite)timeGroup, 0x10000003);
        this.modifiedBefore.setPattern("'Modified before 'd.M.yyy '@' H:mm");
        this.modifiedBefore.setNullText("<choose modified before>");
        this.modifiedBefore.addSelectionListener(selectionListener);
        GridDataFactory.fillDefaults().align(4, 4).hint(-1, 20).span(1, 1).grab(true, false).applyTo((Control)this.modifiedBefore);
        String[] propertyNames = new String[]{"name", "path", "types", "createdBy", "createdAt", "modifiedBy", "modifiedAt"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("name", "Name");
        propertyToLabelMap.put("path", "Path");
        propertyToLabelMap.put("types", "Types");
        propertyToLabelMap.put("createdBy", "Created By");
        propertyToLabelMap.put("createdAt", "Created At");
        propertyToLabelMap.put("modifiedBy", "Last Modified By");
        propertyToLabelMap.put("modifiedAt", "Last Modified At");
        this.bodyDataProvider = new DefaultBodyDataProvider(this.contents, propertyNames);
        DataLayer bodyDataLayer = new DataLayer(this.bodyDataProvider);
        bodyDataLayer.setColumnWidthByPosition(0, 145);
        bodyDataLayer.setColumnWidthByPosition(1, 170);
        bodyDataLayer.setColumnWidthByPosition(2, 120);
        bodyDataLayer.setColumnWidthByPosition(3, 85);
        bodyDataLayer.setColumnWidthByPosition(4, 85);
        bodyDataLayer.setColumnWidthByPosition(5, 115);
        bodyDataLayer.setColumnWidthByPosition(6, 115);
        RowReorderLayer rowReorderLayer = new RowReorderLayer((IUniqueIndexLayer)bodyDataLayer);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)rowReorderLayer);
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
        this.sortModel = new BeanSortModel(this.allContents, this.contents);
        SortHeaderLayer sortHeaderLayer = new SortHeaderLayer((ILayer)columnHeaderLayer, (ISortModel)this.sortModel);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider(this.bodyDataProvider);
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        rowHeaderDataLayer.setColumnWidthByPosition(0, 90);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)sortHeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)viewportLayer, (ILayer)sortHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        this.table = new NatTable(parent, (ILayer)gridLayer, false);
        this.table.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        this.table.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
        this.table.addConfiguration((IConfiguration)new DefaultSelectionStyleConfiguration());
        this.table.addConfiguration((IConfiguration)new AbstractUiBindingConfiguration(){

            public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
                uiBindingRegistry.registerFirstMouseMoveBinding((IMouseEventMatcher)new ColumnResizeEventMatcher(0, "ROW_HEADER", 0), (IMouseAction)new ColumnResizeCursorAction());
                uiBindingRegistry.registerMouseMoveBinding((IMouseEventMatcher)new MouseEventMatcher(), (IMouseAction)new ClearCursorAction());
                uiBindingRegistry.registerFirstMouseDragMode((IMouseEventMatcher)new ColumnResizeEventMatcher(0, "ROW_HEADER", 1), (IDragMode)new ColumnResizeDragMode());
                uiBindingRegistry.registerDoubleClickBinding((IMouseEventMatcher)new ColumnResizeEventMatcher(0, "ROW_HEADER", 1), (IMouseAction)new AutoResizeColumnAction());
                uiBindingRegistry.registerSingleClickBinding((IMouseEventMatcher)new ColumnResizeEventMatcher(0, "ROW_HEADER", 1), (IMouseAction)new NoOpMouseAction());
            }
        });
        this.table.configure();
        GridDataFactory.fillDefaults().align(4, 4).hint(-1, 20).span(4, 1).grab(true, true).applyTo((Control)this.table);
    }

    public void changeLocation(Resource element) {
        this.resource = element;
        try {
            String uri = (String)this.session.syncRequest((Read)new PossibleURI(this.resource));
            if (uri != null) {
                uri = uri.replace("http://Projects/Development%20Project/", "");
                uri = URIStringUtils.unescape((String)uri);
                this.dropLabel.setText("Drag a resource here - searching at " + uri);
            }
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
        this.refresh();
    }

    public void refresh() {
        this.searchAndUpdate();
    }

    public void updateData(boolean sort) {
        this.filter();
        if (sort) {
            this.sortModel.sortCurrent();
        }
        this.table.refresh();
        this.setStatus(DONT_TOUCH, null);
    }

    private long getPossibleTime(CDateTime widget) {
        Date d = widget.getSelection();
        if (d == null) {
            return 0L;
        }
        return d.getTime();
    }

    public void filter() {
        String modifierFilter;
        long createdAfterTime = this.getPossibleTime(this.createdAfter);
        long createdBeforeTime = this.getPossibleTime(this.createdBefore);
        long modifiedAfterTime = this.getPossibleTime(this.modifiedAfter);
        long modifiedBeforeTime = this.getPossibleTime(this.modifiedBefore);
        String creatorFilter = this.creatorText.getText().toLowerCase();
        if (creatorFilter.isEmpty()) {
            creatorFilter = null;
        }
        if ((modifierFilter = this.modifierText.getText().toLowerCase()).isEmpty()) {
            modifierFilter = null;
        }
        String[] nameFilter = null;
        if (!this.nameText.getText().isEmpty()) {
            nameFilter = this.nameText.getText().toLowerCase().split(" ");
        }
        String[] pathFilter = null;
        if (!this.pathText.getText().isEmpty()) {
            pathFilter = this.pathText.getText().toLowerCase().split(" ");
        }
        String[] typesFilter = null;
        if (!this.typesText.getText().isEmpty()) {
            typesFilter = this.typesText.getText().toLowerCase().split(" ");
        }
        this.contents.clear();
        for (Bean b : this.allContents) {
            String t;
            int n;
            int n2;
            String[] stringArray;
            boolean ok;
            String name;
            if (createdAfterTime > 0L && b.createdAt < createdAfterTime || createdBeforeTime > 0L && b.createdAt > createdBeforeTime || modifiedAfterTime > 0L && b.modifiedAt < modifiedAfterTime || modifiedBeforeTime > 0L && b.modifiedAt > modifiedBeforeTime || creatorFilter != null && !b.getCreatedBy().toLowerCase().contains(creatorFilter) || modifierFilter != null && !b.getModifiedBy().toLowerCase().contains(modifierFilter)) continue;
            if (nameFilter != null) {
                name = b.getName().toLowerCase();
                ok = false;
                stringArray = nameFilter;
                n2 = nameFilter.length;
                n = 0;
                while (n < n2) {
                    t = stringArray[n];
                    if (name.contains(t)) {
                        ok = true;
                        break;
                    }
                    ++n;
                }
                if (!ok) continue;
            }
            if (pathFilter != null) {
                name = b.getPath().toLowerCase();
                ok = false;
                stringArray = pathFilter;
                n2 = pathFilter.length;
                n = 0;
                while (n < n2) {
                    t = stringArray[n];
                    if (name.contains(t)) {
                        ok = true;
                        break;
                    }
                    ++n;
                }
                if (!ok) continue;
            }
            if (typesFilter != null) {
                String types = b.getTypes().toLowerCase();
                ok = false;
                stringArray = typesFilter;
                n2 = typesFilter.length;
                n = 0;
                while (n < n2) {
                    t = stringArray[n];
                    if (types.contains(t)) {
                        ok = true;
                        break;
                    }
                    ++n;
                }
                if (!ok) continue;
            }
            this.contents.add(b);
        }
    }

    public void searchAndUpdate() {
        final Display display = WorkbenchUtils.getActiveWorkbenchWindowShell().getDisplay();
        DatabaseJob job = new DatabaseJob("Processing change information"){

            protected IStatus run(final IProgressMonitor monitor) {
                IStatus iStatus;
                try {
                    ChangeInformationComposite.this.allContents.clear();
                    ChangeInformationComposite.this.allContents.addAll((Collection)ChangeInformationComposite.this.session.syncRequest((Read)new UniqueRead<List<Bean>>(){

                        private void browse(ReadGraph graph, Layer0 L0, Resource r, Set<Resource> visited) throws DatabaseException {
                            if (!visited.add(r)) {
                                return;
                            }
                            for (Resource object : graph.getObjects(r, L0.DependsOn)) {
                                this.browse(graph, L0, object, visited);
                            }
                        }

                        public List<Bean> perform(ReadGraph graph) throws DatabaseException {
                            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"Readying change information", (int)100);
                            sub.setTaskName("Searching for change records");
                            ArrayList<Bean> result = new ArrayList<Bean>();
                            if (ChangeInformationComposite.this.resource == null) {
                                return result;
                            }
                            HashSet<Resource> visited = new HashSet<Resource>();
                            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                            this.browse(graph, L0, ChangeInformationComposite.this.resource, visited);
                            sub.worked(30);
                            sub.setTaskName("Processing " + visited.size() + " change records");
                            sub.setWorkRemaining(visited.size());
                            String baseURI = graph.getPossibleURI(ChangeInformationComposite.this.resource);
                            for (Resource r : visited) {
                                ChangeInformation ci = (ChangeInformation)graph.getPossibleRelatedValue(r, MOD.changeInformation, ChangeInformation.BINDING);
                                if (ci != null) {
                                    result.add(new Bean(graph, r, ci, baseURI));
                                }
                                sub.worked(1);
                            }
                            return result;
                        }
                    }));
                    iStatus = Status.OK_STATUS;
                }
                catch (DatabaseException e) {
                    Status status;
                    try {
                        this.showMessage(display, e.getMessage());
                        status = new Status(2, "org.simantics.modeling.ui", "Errors while reading change information.", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        monitor.done();
                        SWTUtils.asyncExec((Display)display, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ChangeInformationComposite.this.updateData(true);
                            }
                        });
                        throw throwable;
                    }
                    monitor.done();
                    SWTUtils.asyncExec((Display)display, (Runnable)new /* invalid duplicate definition of identical inner class */);
                    return status;
                }
                monitor.done();
                SWTUtils.asyncExec((Display)display, (Runnable)new /* invalid duplicate definition of identical inner class */);
                return iStatus;
            }

            private void showMessage(Display display2, final String message) {
                SWTUtils.asyncExec((Display)display2, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ShowMessage.showError((String)"Problems while reading change information", (String)message);
                    }
                });
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

