/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.simantics.modeling.ui.view.Bean;
import org.simantics.utils.strings.AlphanumComparator;

public class BeanSortModel
implements ISortModel {
    protected SortDirectionEnum[] sortDirections;
    protected boolean[] sorted;
    protected int currentSortColumn = -1;
    protected SortDirectionEnum currentSortDirection = SortDirectionEnum.ASC;
    private List<Bean> allBeans;
    private List<Bean> beans;
    private static int NUMBER_OF_COLUMNS = 7;

    public BeanSortModel(List<Bean> allBeans, List<Bean> beans) {
        this.allBeans = allBeans;
        this.beans = beans;
        this.sortDirections = new SortDirectionEnum[NUMBER_OF_COLUMNS];
        Arrays.fill(this.sortDirections, SortDirectionEnum.NONE);
        this.sorted = new boolean[NUMBER_OF_COLUMNS];
        Arrays.fill(this.sorted, false);
        this.sort(0, SortDirectionEnum.ASC, false);
    }

    public List<Integer> getSortedColumnIndexes() {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        if (this.currentSortColumn > -1) {
            indexes.add(this.currentSortColumn);
        }
        return indexes;
    }

    public boolean isColumnIndexSorted(int columnIndex) {
        return this.sorted[columnIndex];
    }

    public SortDirectionEnum getSortDirection(int columnIndex) {
        return this.sortDirections[columnIndex];
    }

    public int getSortOrder(int columnIndex) {
        return 0;
    }

    public void clear() {
        Arrays.fill(this.sortDirections, SortDirectionEnum.NONE);
        Arrays.fill(this.sorted, false);
        this.currentSortColumn = -1;
    }

    public void sort(int columnIndex, SortDirectionEnum sortDirection, boolean accumulate) {
        if (!this.isColumnIndexSorted(columnIndex)) {
            this.clear();
        }
        if (sortDirection.equals((Object)SortDirectionEnum.NONE)) {
            sortDirection = SortDirectionEnum.ASC;
        }
        Collections.sort(this.allBeans, new BeanComparator(columnIndex, sortDirection));
        Collections.sort(this.beans, new BeanComparator(columnIndex, sortDirection));
        this.sortDirections[columnIndex] = sortDirection;
        this.sorted[columnIndex] = !sortDirection.equals((Object)SortDirectionEnum.NONE);
        this.currentSortColumn = columnIndex;
        this.currentSortDirection = sortDirection;
    }

    public List<Comparator> getComparatorsForColumnIndex(int columnIndex) {
        return null;
    }

    public void sortCurrent() {
        if (this.currentSortColumn < 0) {
            return;
        }
        this.sort(this.currentSortColumn, this.currentSortDirection, false);
    }

    class BeanComparator
    implements Comparator<Bean> {
        int colIdx = 0;
        SortDirectionEnum sortDirection;

        public BeanComparator(int columnIndex, SortDirectionEnum sortDirection) {
            this.colIdx = columnIndex;
            this.sortDirection = sortDirection;
        }

        int sort(Bean bean1, Bean bean2) {
            switch (this.colIdx) {
                case 0: {
                    return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)bean1.getName(), (Object)bean2.getName());
                }
                case 1: {
                    return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)bean1.getPath(), (Object)bean2.getPath());
                }
                case 2: {
                    return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)bean1.getTypes(), (Object)bean2.getTypes());
                }
                case 3: {
                    return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)bean1.getCreatedBy(), (Object)bean2.getCreatedBy());
                }
                case 5: {
                    return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)bean1.getModifiedBy(), (Object)bean2.getModifiedBy());
                }
                case 4: {
                    return this.compareLong(bean1.createdAt, bean2.createdAt);
                }
                case 6: {
                    return this.compareLong(bean1.modifiedAt, bean2.modifiedAt);
                }
            }
            return 0;
        }

        private int compareLong(long x, long y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }

        @Override
        public int compare(Bean bean1, Bean bean2) {
            if (SortDirectionEnum.ASC == this.sortDirection) {
                return this.sort(bean1, bean2);
            }
            if (SortDirectionEnum.DESC == this.sortDirection) {
                return this.sort(bean2, bean1);
            }
            return 0;
        }
    }
}

