/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.typicals;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.typicals.SyncTypicalTemplatesToInstances;
import org.simantics.operation.Layer0X;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.ui.ErrorLogger;

public class SyncActiveModelTypicals
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        Session session = Simantics.getSession();
        try {
            Resource[] activeModelTypicalTemplates = (Resource[])session.syncRequest((Read)new Read<Resource[]>(){

                public Resource[] perform(ReadGraph graph) throws DatabaseException {
                    Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                    ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                    SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                    Collection activeModels = (Collection)graph.syncRequest((Read)new ObjectsWithType(Simantics.getProjectResource(), L0X.Activates, SIMU.Model));
                    Instances query = (Instances)graph.adapt(MOD.MasterTypicalCompositeType, Instances.class);
                    HashSet<Resource> result = new HashSet<Resource>();
                    for (Resource activeModel : activeModels) {
                        Collection typicalComposites = query.find(graph, activeModel);
                        for (Resource typicalComposite : typicalComposites) {
                            for (Resource typicalDiagram : graph.getObjects(typicalComposite, MOD.CompositeToDiagram)) {
                                result.add(typicalDiagram);
                            }
                        }
                    }
                    return result.toArray(Resource.NONE);
                }
            });
            if (activeModelTypicalTemplates.length > 0) {
                StringBuilder msg = new StringBuilder("Are you sure you want to synchronize ").append(activeModelTypicalTemplates.length).append(" typical template");
                if (activeModelTypicalTemplates.length > 1) {
                    msg.append("s to all their instances?");
                } else {
                    msg.append(" to all its instances?");
                }
                if (MessageDialog.openConfirm((Shell)shell, (String)"Synchronize All Typical Templates with Instances", (String)msg.toString())) {
                    session.syncRequest((Write)new SyncTypicalTemplatesToInstances(activeModelTypicalTemplates));
                }
            }
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        return null;
    }
}

