/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.typicals;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.modeling.ModelingResources;
import org.simantics.scl.runtime.function.Function2;
import org.simantics.ui.workbench.action.ChooseActionRequest;
import org.simantics.ui.workbench.dialogs.ElementListSelectionDialog;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class NewTypicalDiagramInstance
implements ActionFactory {
    public Runnable create(Object target_) {
        final Resource target = (Resource)target_;
        return new Runnable(){

            @Override
            public void run() {
                DatabaseJob job = new DatabaseJob("Instantiate Typical"){

                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.beginTask("Instantiate Typical...", -1);
                        Session session = Simantics.getSession();
                        try {
                            final AtomicReference model = new AtomicReference();
                            Function2 instantiator = (Function2)session.syncRequest((Read)new UniqueRead<Function2<Resource, Resource, Resource>>(){

                                public Function2<Resource, Resource, Resource> perform(ReadGraph graph) throws DatabaseException {
                                    model.set((Resource)graph.sync((ReadInterface)new PossibleModel(target)));
                                    if (model.get() == null) {
                                        throw new CancelTransactionException("Cannot find a model from the input selection. Typical diagram instantiation not possible.");
                                    }
                                    ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                                    Function2 instantiator = (Function2)graph.getRelatedValue2((Resource)model.get(), MOD.StructuralModel_typicalInstantiationFunction);
                                    return instantiator;
                                }
                            });
                            instantiator.apply((Object)((Resource)model.get()), (Object)target);
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        catch (CancelTransactionException e) {
                            Status status = new Status(1, "org.simantics.modeling.ui", e.getMessage());
                            return status;
                        }
                        catch (DatabaseException e) {
                            Status status = new Status(4, "org.simantics.modeling.ui", e.getMessage(), (Throwable)e);
                            return status;
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                job.schedule();
            }
        };
    }

    public static <T> void asyncQueryFromList(final Collection<T> elements, final Callback<T> callback) {
        SWTUtils.asyncExec((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                Object result = NewTypicalDiagramInstance.queryFromList(elements);
                if (callback != null) {
                    callback.run(result);
                }
            }
        });
    }

    public static <T> T queryFromList(Collection<T> elements) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window != null ? window.getShell() : null;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider());
        dialog.setBlockOnOpen(true);
        dialog.setTitle("Select Template Typical Diagram");
        dialog.setMessage("Select typical diagram to copy (? = any character, * = any string):");
        dialog.setMultipleSelection(false);
        dialog.setMatchEmptyString(true);
        dialog.setElements(elements);
        if (dialog.open() != 0) {
            return null;
        }
        return (T)dialog.getFirstResult();
    }

    public static void asyncPerformDefaultAction(final Session session, final Object input) {
        SWTUtils.asyncExec((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                NewTypicalDiagramInstance.performDefaultAction(session, input);
            }
        });
    }

    public static void performDefaultAction(Session session, Object input) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window != null ? window.getShell() : null;
        session.asyncRequest((Read)new ChooseActionRequest(shell, null, input, WorkbenchUtils.getCurrentPerspectiveId(), false, false, true));
    }
}

