/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.symbolEditor;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.adapter.GraphToDiagramSynchronizer;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.ElementWriter;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramMutator;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.dnd.DnDHints;
import org.simantics.g2d.dnd.ElementClassDragItem;
import org.simantics.g2d.dnd.IDnDContext;
import org.simantics.g2d.dnd.IDragItem;
import org.simantics.g2d.dnd.IDropTargetParticipant;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.symbolEditor.PopulateTerminal;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.LocalObjectTransferable;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ErrorLogger;

public class PopulateTerminalDropParticipant
extends AbstractDiagramParticipant
implements IDropTargetParticipant {
    private static final IHintContext.Key KEY_TERMINAL_RELATION = new IHintContext.KeyOf(Resource.class, "TERMINAL_RELATION");
    protected GraphToDiagramSynchronizer synchronizer;
    protected Resource symbolDiagram;

    public PopulateTerminalDropParticipant(Resource symbolDiagram, GraphToDiagramSynchronizer synchronizer) {
        this.symbolDiagram = symbolDiagram;
        this.synchronizer = synchronizer;
    }

    public void dragEnter(DropTargetDragEvent dtde, final IDnDContext dp) {
        Transferable tr = dtde.getTransferable();
        if (tr.isDataFlavorSupported(LocalObjectTransferable.FLAVOR)) {
            Session session = this.synchronizer.getSession();
            try {
                tr.getTransferData(LocalObjectTransferable.FLAVOR);
                final Resource[] resources = ResourceAdaptionUtils.toResources((Object)LocalObjectTransfer.getTransfer().getObject());
                int itemsAdded = (Integer)session.syncRequest((Read)new Read<Integer>(){

                    public Integer perform(ReadGraph g) throws DatabaseException {
                        int items = 0;
                        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
                        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
                        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
                        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
                        Resource symbol = g.getPossibleObject(PopulateTerminalDropParticipant.this.symbolDiagram, STR.Defines);
                        if (symbol == null) {
                            return 0;
                        }
                        Resource componentType = g.getPossibleObject(symbol, MOD.SymbolToComponentType);
                        if (componentType == null) {
                            return 0;
                        }
                        HashSet connectionRelationsOfSymbol = new HashSet((Collection)g.syncRequest((Read)new ObjectsWithType(componentType, L0.ConsistsOf, STR.ConnectionRelation)));
                        HashSet<Resource> usedConnectionRelations = new HashSet<Resource>();
                        for (Resource terminal : (Collection)g.syncRequest((Read)new ObjectsWithType(PopulateTerminalDropParticipant.this.symbolDiagram, L0.ConsistsOf, DIA.Terminal))) {
                            Resource binds = DiagramGraphUtil.getPossibleConnectionPointOfTerminal((ReadGraph)g, (Resource)terminal);
                            if (binds == null) continue;
                            for (Resource connRel : g.getObjects(binds, MOD.DiagramConnectionRelationToConnectionRelation)) {
                                usedConnectionRelations.add(connRel);
                            }
                        }
                        Resource[] resourceArray = resources;
                        int n = resources.length;
                        int n2 = 0;
                        while (n2 < n) {
                            block11: {
                                Resource connectionRelation;
                                ElementClassDragItem di;
                                block10: {
                                    Resource resource = resourceArray[n2];
                                    di = null;
                                    connectionRelation = null;
                                    if (!g.isInstanceOf(resource, STR.ConnectionRelation)) break block10;
                                    if (!connectionRelationsOfSymbol.contains(resource)) break block11;
                                    Resource terminal = g.getPossibleObject(resource, MOD.ConnectionRelationToTerminal);
                                    if (terminal == null) {
                                        terminal = MOD.TestTerminal;
                                    }
                                    di = new ElementClassDragItem(PopulateTerminalDropParticipant.this.synchronizer.getNodeClass((RequestProcessor)g, terminal));
                                    connectionRelation = resource;
                                }
                                if (di != null && connectionRelation != null && !usedConnectionRelations.contains(connectionRelation)) {
                                    di.getHintContext().setHint(KEY_TERMINAL_RELATION, connectionRelation);
                                    dp.add(di);
                                    ++items;
                                }
                            }
                            ++n2;
                        }
                        return items;
                    }
                });
                if (itemsAdded > 0) {
                    dp.getHints().setHint(DnDHints.KEY_DND_GRID_COLUMNS, (Object)1);
                    dtde.acceptDrag(1);
                }
            }
            catch (DatabaseException e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
            catch (UnsupportedFlavorException e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
            catch (IOException e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
        }
    }

    public void dragExit(DropTargetEvent dte, IDnDContext dp) {
    }

    public void dragOver(DropTargetDragEvent dtde, IDnDContext dp) {
    }

    public void drop(DropTargetDropEvent dtde, final IDnDContext dp) {
        IDiagram d = (IDiagram)this.getHint(DiagramHints.KEY_DIAGRAM);
        if (d == null) {
            return;
        }
        DiagramUtils.mutateDiagram((IDiagram)d, (Callback)new Callback<DiagramMutator>(){

            public void run(DiagramMutator mutator) {
                IDragItem[] items;
                IDragItem[] iDragItemArray = items = (IDragItem[])dp.toArray();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    Resource relation;
                    IDragItem i = iDragItemArray[n2];
                    if (i instanceof ElementClassDragItem && (relation = (Resource)i.getHintContext().getHint(KEY_TERMINAL_RELATION)) != null) {
                        ElementClassDragItem res = (ElementClassDragItem)i;
                        ElementClass ec = res.getElementClass();
                        Point2D pos = dp.getItemPosition(i);
                        if (!$assertionsDisabled && pos == null) {
                            throw new AssertionError();
                        }
                        IElement element = mutator.newElement(ec);
                        ElementUtils.setPos((IElement)element, (Point2D)new Point2D.Double(pos.getX(), pos.getY()));
                        element.setHint(DiagramModelHints.KEY_ELEMENT_WRITER, (Object)new ElementWriter(){

                            public void addToGraph(WriteGraph g, IElement element, Resource terminal) throws DatabaseException {
                                PopulateTerminal.addToGraph((WriteGraph)g, (Resource)(this).PopulateTerminalDropParticipant.this.symbolDiagram, (Resource)relation, (Resource)terminal);
                            }

                            public void removeFromGraph(WriteGraph graph, Resource elementResource) {
                            }
                        });
                        dp.remove((Object)i);
                    }
                    ++n2;
                }
            }
        });
        this.getContext().getContentContext().setDirty();
    }

    public void dropActionChanged(DropTargetDragEvent dtde, IDnDContext dp) {
        dtde.acceptDrag(1);
    }

    public int getAllowedOps() {
        return 0x40000003;
    }
}

