/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.sharedontology.wizard;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Deque;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.databoard.container.DataFormatException;
import org.simantics.databoard.container.FormatHandler;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.migration.MigrationUtils;
import org.simantics.db.management.ISessionContext;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.modeling.ui.sharedontology.wizard.ImportPlan;
import org.simantics.modeling.ui.sharedontology.wizard.Preferences;
import org.simantics.modeling.ui.sharedontology.wizard.SharedOntologyImportPage;
import org.simantics.modeling.ui.utils.NoProjectPage;
import org.simantics.project.IProject;
import org.simantics.project.ProjectKeys;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;

public class SharedOntologyImportWizard
extends Wizard
implements IImportWizard {
    private static final int MAX_RECENT_IMPORT_PATHS = 10;
    ImportPlan importModel;

    private boolean readPreferences(IStructuredSelection selection) {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling.ui");
        String recentPathsPref = store.getString("RECENT_SHARED_LIBRARY_IMPORT_LOCATIONS");
        Deque<String> recentImportPaths = Preferences.decodePaths(recentPathsPref);
        ISessionContext ctx = SimanticsUI.getSessionContext();
        if (ctx == null) {
            return false;
        }
        IProject project = (IProject)ctx.getHint(ProjectKeys.KEY_PROJECT);
        if (project == null) {
            return false;
        }
        this.importModel = new ImportPlan(ctx, recentImportPaths);
        this.importModel.project = project;
        this.importModel.selection = selection.getFirstElement();
        return true;
    }

    private void writePreferences() throws IOException {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling.ui");
        store.putValue("RECENT_SHARED_LIBRARY_IMPORT_LOCATIONS", Preferences.encodePaths(this.importModel.recentLocations));
        if (store.needsSaving()) {
            store.save();
        }
    }

    public SharedOntologyImportWizard() {
        this.setWindowTitle("Import Shared Library");
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.readPreferences(selection);
    }

    public void addPages() {
        super.addPages();
        if (this.importModel != null) {
            this.addPage((IWizardPage)new SharedOntologyImportPage(this.importModel));
        } else {
            this.addPage((IWizardPage)new NoProjectPage("Import Shared Library"));
        }
    }

    public boolean performFinish() {
        try {
            this.importModel.recentLocations.addFirst(this.importModel.importLocation.getAbsolutePath());
            Preferences.removeDuplicates(this.importModel.recentLocations);
            if (this.importModel.recentLocations.size() > 10) {
                this.importModel.recentLocations.pollLast();
            }
            this.writePreferences();
        }
        catch (IOException e) {
            ErrorLogger.defaultLogError((String)"Failed to write preferences", (Throwable)e);
        }
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        Resource target = ResourceAdaptionUtils.toSingleResource((Object)SharedOntologyImportWizard.this.importModel.selection);
                        SharedOntologyImportWizard.doImport(monitor, SharedOntologyImportWizard.this.importModel.importLocation, SharedOntologyImportWizard.this.importModel.sessionContext.getSession(), target);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            WizardPage cp = (WizardPage)this.getContainer().getCurrentPage();
            if (t instanceof IOException) {
                cp.setErrorMessage("An I/O problem occurred while importing shared library.\n\nMessage: " + e.getMessage());
            }
            ErrorLogger.defaultLogError((Throwable)t);
            return false;
        }
        catch (InterruptedException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
            return false;
        }
        return true;
    }

    public static void doImport(final IProgressMonitor monitor, File modelFile, final Session session, Resource target) throws IOException, SerializationException, DatabaseException {
        try {
            try {
                monitor.beginTask("Loading shared library from disk", 1000);
                try {
                    FormatHandler<Object> handler1 = new FormatHandler<Object>(){

                        public Binding getBinding() {
                            return TransferableGraph1.BINDING;
                        }

                        public Object process(DataContainer container) throws Exception {
                            monitor.worked(100);
                            monitor.setTaskName("Importing shared library into database");
                            TransferableGraph1 tg = (TransferableGraph1)container.content.getValue();
                            MigrationUtils.importSharedOntology((Session)session, (TransferableGraph1)tg);
                            monitor.worked(850);
                            return null;
                        }
                    };
                    HashMap<String, 2> handlers = new HashMap<String, 2>();
                    handlers.put("sharedLibrary:1", handler1);
                    try {
                        DataContainers.readFile((File)modelFile, handlers);
                    }
                    catch (DataFormatException e) {
                        throw new IOException(e);
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                }
                catch (IOException handler1) {
                    // empty catch block
                }
                monitor.setTaskName("Postprocessing");
                monitor.worked(50);
            }
            catch (Throwable t) {
                t.printStackTrace();
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

