/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.sharedontology.wizard;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.simantics.Simantics;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.db.RequestProcessor;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ModelingUtils;
import org.simantics.modeling.ui.sharedontology.wizard.ExportPlan;
import org.simantics.utils.ui.dialogs.ShowMessage;

public class SharedOntologyExporter
implements IRunnableWithProgress {
    ExportPlan exportModel;

    public SharedOntologyExporter(ExportPlan exportModel) {
        this.exportModel = exportModel;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)50);
        try {
            try {
                this.exportModel(progress.newChild(50, 0));
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            catch (DatabaseException e) {
                throw new InvocationTargetException(e);
            }
            catch (BindingException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    void exportModel(SubMonitor mon) throws IOException, DatabaseException, SerializationException, BindingException {
        try {
            try {
                SharedOntologyExporter.doExport((IProgressMonitor)mon, this.exportModel.exportLocation, this.exportModel.model);
            }
            catch (DatabaseException e) {
                e.printStackTrace();
                Logger.defaultLogError((Throwable)e);
                mon.setCanceled(true);
                ShowMessage.showError((String)"Export failed.", (String)"Internal application error in export. See log for details.");
                mon.setWorkRemaining(0);
            }
        }
        finally {
            mon.setWorkRemaining(0);
        }
    }

    public static void doExport(IProgressMonitor monitor, File location, ModelingUtils.LibraryInfo info) throws DatabaseException, IOException {
        ModelingUtils.exportSharedOntology((IProgressMonitor)monitor, (RequestProcessor)Simantics.getSession(), (File)location, (String)"sharedLibrary", (int)1, (ModelingUtils.LibraryInfo)info);
    }
}

