/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.property;

import org.eclipse.core.expressions.PropertyTester;
import org.simantics.DatabaseJob;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;

public class ComponentTypePropertyTester
extends PropertyTester {
    private static final String PART_OF = "partOf";

    public boolean test(Object receiver, final String property, final Object[] args, final Object expectedValue) {
        final Resource resource = ResourceAdaptionUtils.toSingleResource((Object)receiver);
        if (resource == null) {
            return false;
        }
        Session session = SimanticsUI.peekSession();
        if (session == null) {
            return false;
        }
        if (DatabaseJob.inProgress()) {
            return false;
        }
        try {
            return (Boolean)session.syncRequest((Read)new Read<Boolean>(){

                public Boolean perform(ReadGraph g) throws DatabaseException {
                    return ComponentTypePropertyTester.this.doTest(g, resource, property, args, expectedValue);
                }
            });
        }
        catch (DatabaseException e) {
            return false;
        }
    }

    private boolean doTest(ReadGraph graph, Resource resource, String property, Object[] args, Object expectedValue) throws DatabaseException {
        if (PART_OF.equals(property)) {
            boolean is;
            boolean expected = this.parseBoolean(expectedValue, true);
            boolean bl = is = this.partOfComponentType(graph, resource) != null;
            return is == expected;
        }
        return false;
    }

    private Resource partOfComponentType(ReadGraph graph, Resource resource) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource componentType = null;
        Resource curComponent = resource;
        do {
            if ((componentType = graph.getPossibleObject(curComponent, STR.Defines)) == null) continue;
            return componentType;
        } while ((curComponent = graph.getPossibleObject(curComponent, L0.PartOf)) != null);
        return null;
    }

    boolean parseBoolean(Object value, boolean defaultValue) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return defaultValue;
    }
}

