/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.preferences;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.history.csv.ExportInterpolation;

public class CSVPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private StringFieldEditor fDecimalSeparator = null;
    private StringFieldEditor fValueSeparatorEditor = null;
    private StringFieldEditor fExtensionEditor = null;
    private BooleanFieldEditor fResamplingEditor = null;
    private ComboFieldEditor fSamplingModeEditor = null;
    private StringFieldEditor fStartEditor = null;
    private StringFieldEditor fStepEditor = null;
    private IntegerFieldEditor fTimeDigitsEditor = null;
    private IntegerFieldEditor fFloatDigitsEditor = null;
    private IntegerFieldEditor fDoubleDigitsEditor = null;

    public CSVPreferencePage() {
        super(1);
        this.setDescription("CSV import and export preferences");
        ScopedPreferenceStore pf = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling");
        this.setPreferenceStore((IPreferenceStore)pf);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        this.fDecimalSeparator = new StringFieldEditor("csv.decimal.separator", "Decimal separator", this.getFieldEditorParent());
        this.fDecimalSeparator.setValidateStrategy(1);
        this.fDecimalSeparator.setErrorMessage("Valid decimal separator is required.");
        this.fDecimalSeparator.setEmptyStringAllowed(false);
        this.addField((FieldEditor)this.fDecimalSeparator);
        this.fValueSeparatorEditor = new StringFieldEditor("csv.value.separator", "Column separator", this.getFieldEditorParent());
        this.fValueSeparatorEditor.setEmptyStringAllowed(false);
        this.addField((FieldEditor)this.fValueSeparatorEditor);
        this.fExtensionEditor = new StringFieldEditor("csv.file.extension", "File extension", this.getFieldEditorParent());
        this.addField((FieldEditor)this.fExtensionEditor);
        this.fResamplingEditor = new BooleanFieldEditor("csv.resample", "Resampling", this.getFieldEditorParent());
        this.addField((FieldEditor)this.fResamplingEditor);
        this.fSamplingModeEditor = new ComboFieldEditor("csv.sampling.mode", "Sampling mode", (String[][])new String[][]{{ExportInterpolation.LINEAR_INTERPOLATION.label, ExportInterpolation.LINEAR_INTERPOLATION.preference}, {ExportInterpolation.PREVIOUS_SAMPLE.label, ExportInterpolation.PREVIOUS_SAMPLE.preference}}, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fSamplingModeEditor);
        this.fStartEditor = new StringFieldEditor("csv.start", "Start time (s)", this.getFieldEditorParent()){

            protected boolean doCheckState() {
                String text = this.getTextControl().getText();
                if (text == null || text.isEmpty()) {
                    return true;
                }
                try {
                    double number = Double.parseDouble(text);
                    return number > 0.0;
                }
                catch (NumberFormatException e1) {
                    return false;
                }
            }
        };
        this.fStartEditor.setEmptyStringAllowed(true);
        this.fStartEditor.setErrorMessage("Enter valid start time value (s)");
        this.fStepEditor = new StringFieldEditor("csv.step", "Step size (s)", this.getFieldEditorParent()){

            protected boolean doCheckState() {
                String text = this.getTextControl().getText();
                if (text == null || text.isEmpty()) {
                    return true;
                }
                try {
                    double number = Double.parseDouble(text);
                    return number > 0.0;
                }
                catch (NumberFormatException e1) {
                    return false;
                }
            }
        };
        this.fStepEditor.setEmptyStringAllowed(true);
        this.fStepEditor.setErrorMessage("Enter valid time step value (s)");
        this.addField((FieldEditor)this.fStepEditor);
        Group significantDigitsGroup = new Group(this.getFieldEditorParent(), 0);
        significantDigitsGroup.setText("Significant digits");
        significantDigitsGroup.setToolTipText("Control the Amount of Significant Digits in Exported Numbers");
        GridDataFactory.fillDefaults().indent(0, 5).span(2, 1).applyTo((Control)significantDigitsGroup);
        this.fTimeDigitsEditor = new IntegerFieldEditor("csv.format.time.digits", "Time stamps", (Composite)significantDigitsGroup, 2);
        this.fTimeDigitsEditor.setValidRange(1, 15);
        this.addField((FieldEditor)this.fTimeDigitsEditor);
        this.fFloatDigitsEditor = new IntegerFieldEditor("csv.format.float.digits", "Single precision floating point", (Composite)significantDigitsGroup, 1);
        this.fFloatDigitsEditor.setValidRange(1, 7);
        this.addField((FieldEditor)this.fFloatDigitsEditor);
        this.fDoubleDigitsEditor = new IntegerFieldEditor("csv.format.double.digits", "Double precision floating point", (Composite)significantDigitsGroup, 2);
        this.fDoubleDigitsEditor.setValidRange(1, 15);
        this.addField((FieldEditor)this.fDoubleDigitsEditor);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)significantDigitsGroup);
    }
}

