/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfWriter;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.diagram.elements.DiagramNodeUtil;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.scenegraph.ICanvasSceneGraphProvider;
import org.simantics.modeling.requests.Node;
import org.simantics.modeling.ui.pdf.PDFBuilder;
import org.simantics.modeling.ui.pdf.PDFExportPlan;
import org.simantics.structural2.StructuralVariables;
import org.simantics.utils.DataContainer;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.page.PageDesc;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class PDFPainter {
    public static boolean render(final IThreadWorkQueue thread, final ISessionContext sessionContext, PDFExportPlan exportModel, final Node node, final PdfWriter writer, final FontMapper mapper, final Rectangle pageSize, final PageDesc pageDesc, final boolean fitDiagramContentsToPageMargins, long timeout) throws InterruptedException, DatabaseException {
        DataContainer result = new DataContainer((Object)false);
        final DataContainer exception = new DataContainer();
        final CanvasContext ctx = new CanvasContext(thread);
        final AtomicReference sgProvider = new AtomicReference();
        try {
            final Semaphore done = new Semaphore(0);
            ThreadUtils.getBlockingWorkExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            Pair modelAndRVI = (Pair)sessionContext.getSession().syncRequest((Read)new UniqueRead<Pair<Resource, String>>(){

                                public Pair<Resource, String> perform(ReadGraph graph) throws DatabaseException {
                                    return new Pair((Object)PDFPainter.resolveModel(graph, node), (Object)PDFPainter.resolveRVI(graph, node));
                                }
                            });
                            ICanvasSceneGraphProvider provider = DiagramNodeUtil.loadSceneGraphProvider((ICanvasContext)ctx, (Resource)((Resource)modelAndRVI.first), (Resource)node.getDiagramResource(), (String)((String)modelAndRVI.second));
                            sgProvider.set(provider);
                            ctx.getDefaultHintContext().setHint(Hints.KEY_PAGE_DESC, (Object)pageDesc);
                            ThreadUtils.asyncExec((IThreadWorkQueue)thread, (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        PDFBuilder chassis = new PDFBuilder(writer, mapper, pageSize, pageDesc, fitDiagramContentsToPageMargins);
                                        chassis.paint((ICanvasContext)ctx, true);
                                    }
                                    finally {
                                        done.release();
                                    }
                                }
                            });
                        }
                        catch (DatabaseException e) {
                            done.release();
                            exception.set((Object)e);
                            done.release();
                        }
                        catch (Throwable e) {
                            done.release();
                            exception.set((Object)new DatabaseException(e));
                            done.release();
                        }
                    }
                    finally {
                        done.release();
                    }
                }
            });
            done.acquire(2);
            if (exception.get() != null) {
                throw (DatabaseException)((Object)exception.get());
            }
            boolean bl = (Boolean)result.get();
            return bl;
        }
        finally {
            if (sgProvider.get() != null) {
                ((ICanvasSceneGraphProvider)sgProvider.get()).dispose();
            }
            ctx.dispose();
        }
    }

    private static Resource resolveModel(ReadGraph graph, Node node) throws DatabaseException {
        Resource composite = node.getDefiningResources().head();
        Resource model = StructuralVariables.getModel((ReadGraph)graph, (Resource)composite);
        if (model == null) {
            throw new ValidationException("no model found for composite " + NameUtils.getSafeName((ReadGraph)graph, (Resource)composite));
        }
        return model;
    }

    private static String resolveRVI(ReadGraph graph, Node node) throws DatabaseException {
        String RVI2 = node.getRVI();
        if (RVI2 != null) {
            return RVI2;
        }
        Resource composite = node.getDefiningResources().head();
        ResourceArray compositePath = StructuralVariables.getCompositeArray((ReadGraph)graph, (Resource)composite);
        ResourceArray variablePath = compositePath.removeFromBeginning(1);
        return StructuralVariables.getRVI((ReadGraph)graph, (ResourceArray)variablePath);
    }
}

