/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.pdf;

import com.kitfox.svg.SVGCache;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.SessionGarbageCollection;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.document.DocumentUtils;
import org.simantics.modeling.requests.CollectionRequest;
import org.simantics.modeling.requests.CollectionResult;
import org.simantics.modeling.requests.Node;
import org.simantics.modeling.ui.pdf.PDFExportPlan;
import org.simantics.modeling.ui.pdf.PDFPainter;
import org.simantics.modeling.ui.pdf.PdfException;
import org.simantics.modeling.ui.preferences.DiagramPreferenceUtil;
import org.simantics.ui.jobs.SessionGarbageCollectorJob;
import org.simantics.utils.page.PageDesc;
import org.simantics.utils.page.PageOrientation;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.WorkerThread;

public class DiagramPrinter {
    private static final AtomicBoolean fontFactoryInitialized = new AtomicBoolean();

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static CollectionResult browse(IProgressMonitor monitor, RequestProcessor processor, Resource[] input) throws DatabaseException {
        CollectionResult result = (CollectionResult)processor.syncRequest((Read)new CollectionRequest(monitor, DiagramPreferenceUtil.getDefaultPreferences().getCompletePageDesc(), input));
        return result;
    }

    public static void printToPdf(IProgressMonitor monitor, PDFExportPlan exportPlan, String exportPath, Collection<Node> flattenedNodes, ISessionContext sessionContext) throws PdfException {
        Collection<Node> flattened = flattenedNodes;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Export to PDF", (int)(flattened.size() * 2));
        WorkerThread workerThread = new WorkerThread("Diagram PDF Painter");
        workerThread.start();
        PdfWriter writer = null;
        Document document = null;
        try {
            try {
                progress.subTask("Loading system fonts");
                DefaultFontMapper mapper = new DefaultFontMapper();
                if (fontFactoryInitialized.compareAndSet(false, true)) {
                    FontFactory.registerDirectories();
                }
                SessionGarbageCollectorJob.getInstance().setEnabled(false);
                boolean first = true;
                int i = 0;
                for (Node d : flattened) {
                    ++i;
                    Rectangle pageSize = DiagramPrinter.toPageSize(d.getPageDesc());
                    if (writer == null) {
                        document = new Document(pageSize);
                        writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(exportPath));
                        writer.setPdfVersion(PdfWriter.PDF_VERSION_1_7);
                        if (exportPlan.attachTG) {
                            writer.addViewerPreference(PdfName.USEATTACHMENTS, (PdfObject)PdfBoolean.PDFTRUE);
                        }
                        String creator = DiagramPrinter.getCreator();
                        document.addCreator(creator);
                        document.open();
                    }
                    if (!first) {
                        document.setPageSize(pageSize);
                        document.newPage();
                    }
                    String diagramName = DiagramPrinter.formDiagramName(d, true);
                    String subTask = "Page (" + i + "/" + flattened.size() + "): " + diagramName;
                    Resource diagram = d.getDiagramResource();
                    if (diagram == null) {
                        subTask = String.valueOf(subTask) + " skipped, no diagram.";
                        System.out.println(subTask);
                        continue;
                    }
                    System.out.println(subTask);
                    progress.subTask(subTask);
                    try {
                        PDFPainter.render((IThreadWorkQueue)workerThread, sessionContext, exportPlan, d, writer, (FontMapper)mapper, pageSize, d.getPageDesc(), exportPlan.fitContentToPageMargins, 10000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (DatabaseException e) {
                        e.printStackTrace();
                    }
                    int w = (int)pageSize.getWidth();
                    int h = (int)pageSize.getHeight();
                    PdfContentByte cb = writer.getDirectContent();
                    if (exportPlan.attachWiki && !d.getDefiningResources().isEmpty()) {
                        Session session = exportPlan.sessionContext.getSession();
                        Resource composite = (Resource)d.getDefiningResources().iterator().next();
                        DocumentUtils du = new DocumentUtils();
                        StringBuilder sb = new StringBuilder();
                        du.getDocumentWikiText(session, composite, sb);
                        PdfTemplate tp_ = cb.createTemplate((float)w, (float)h);
                        if (sb.length() > 0) {
                            String wikiText = sb.toString();
                            du.print(wikiText, tp_.getPdfWriter(), document);
                        }
                        cb.addTemplate(tp_, 0.0f, 0.0f);
                    }
                    progress.worked(1);
                    first = false;
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    System.out.println("GC");
                    SVGCache.getSVGUniverse().clearUnreferenced();
                    SessionGarbageCollection.gc(null, (Session)sessionContext.getSession(), (boolean)true, null);
                    System.gc();
                    System.out.println("GC finished");
                }
            }
            catch (FileNotFoundException e) {
                throw new PdfException(e);
            }
            catch (DocumentException e) {
                throw new PdfException(e);
            }
        }
        finally {
            workerThread.stopDispatchingEvents(true);
            System.out.println("closing document");
            try {
                if (document != null) {
                    document.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            System.out.println("document closed");
            SessionGarbageCollectorJob.getInstance().setEnabled(true).scheduleAfterQuietTime();
        }
    }

    public static Rectangle toPageSize(PageDesc pageDesc) {
        String arg = String.valueOf(PageDesc.toPoints((double)pageDesc.getWidth())) + " " + PageDesc.toPoints((double)pageDesc.getHeight());
        Rectangle r = PageSize.getRectangle((String)arg);
        if (PageOrientation.Landscape == pageDesc.getOrientation()) {
            r = r.rotate();
        }
        r.setBorder(0);
        return r;
    }

    public static String formDiagramName(Node node, boolean parents) {
        Node d = node;
        String ret = d.getName();
        if (parents) {
            while (d.getParent() != null) {
                d = d.getParent();
                ret = String.valueOf(d.getName()) + " / " + ret;
            }
        }
        return ret;
    }

    public static String getCreator() {
        String creator = null;
        IProduct product = Platform.getProduct();
        if (product != null && (creator = product.getDescription()) == null) {
            creator = product.getName();
        }
        if (creator == null) {
            creator = "Simantics";
        }
        return creator;
    }
}

