/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.modelBrowser.handlers;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.adapter.CopyHandler;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsClipboardBuilder;
import org.simantics.db.layer0.util.SimanticsClipboardImpl;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class StandardCopyHandler
extends AbstractHandler {
    private static IStatusLineManager status;

    private static List<Variable> getVariables(ISelection selection) {
        NodeContext context = (NodeContext)ISelectionUtils.getSinglePossibleKey((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, NodeContext.class);
        if (context == null) {
            return Collections.emptyList();
        }
        IHintContext hints = (IHintContext)context.getConstant(BuiltinKeys.INPUT);
        if (hints == null) {
            return Collections.emptyList();
        }
        Variable var = (Variable)hints.getHint(SelectionHints.KEY_SELECTION_PROPERTY);
        if (var == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(var);
    }

    private boolean copyText(ISelection selection) {
        Object element;
        StructuredSelection sel;
        if (selection instanceof StructuredSelection && (sel = (StructuredSelection)selection).size() == 1 && (element = sel.getFirstElement()) instanceof String) {
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            TextTransfer textTransfer = TextTransfer.getInstance();
            Transfer[] transfers = new Transfer[]{textTransfer};
            Object[] data = new Object[]{element};
            clipboard.setContents(data, transfers);
            clipboard.dispose();
        }
        return false;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        status = WorkbenchUtils.getStatusLine((IWorkbenchSite)HandlerUtil.getActiveSite((ExecutionEvent)event));
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (this.copyText(selection)) {
            return null;
        }
        Resource[] rs = ResourceAdaptionUtils.toResources((Object)selection);
        StandardCopyHandler.copyResourcesToClipboard(rs, selection);
        return null;
    }

    public static String copyResourcesToClipboard(final Resource[] rs, ISelection selection) {
        if (rs == null || rs.length == 0) {
            List<Variable> variables = StandardCopyHandler.getVariables(selection);
            if (!variables.isEmpty()) {
                SimanticsClipboardImpl builder = new SimanticsClipboardImpl();
                for (Variable var : variables) {
                    builder.addContent(Collections.singleton(ClipboardUtils.createVariable((RequestProcessor)Simantics.getSession(), (Variable)var)));
                }
                Simantics.setClipboard((SimanticsClipboard)builder);
                StandardCopyHandler.setCopyMessage(builder.getContents().size(), "variable");
                return null;
            }
            StandardCopyHandler.setCopyMessage(0, "");
            return null;
        }
        try {
            final SimanticsClipboardImpl builder = new SimanticsClipboardImpl();
            Simantics.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    Resource[] resourceArray = rs;
                    int n = rs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Resource r = resourceArray[n2];
                        CopyHandler handler = (CopyHandler)graph.adapt(r, CopyHandler.class);
                        handler.copyToClipboard(graph, (SimanticsClipboardBuilder)builder);
                        ++n2;
                    }
                }
            });
            Simantics.setClipboard((SimanticsClipboard)builder);
            StandardCopyHandler.setCopyMessage(builder.getContents().size(), "resource");
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
        return null;
    }

    private static void setCopyMessage(int count, String elementName) {
        if (count > 1) {
            StandardCopyHandler.setStatus("Copied " + count + " " + elementName + "s to clipboard");
        } else if (count == 1) {
            StandardCopyHandler.setStatus("Copied " + elementName + " to clipboard");
        } else {
            StandardCopyHandler.setStatus("Nothing to copy.");
        }
    }

    private static void setStatus(String message) {
        if (status != null) {
            status.setMessage(message);
        }
    }
}

